package com.bailuntec.serviceImpl;

import com.bailuntec.dao.DcAccountingEntryTaskDao;
import com.bailuntec.domain.entity.DcAccountingEntryTask;
import com.bailuntec.service.AccountingEntryService;
import com.qiniu.common.Region;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.time.LocalDateTime;

@Slf4j
@Service
public class AccountingEntryServiceImpl implements AccountingEntryService {
    @Value("${config.qiniu.access-key}")
    public String accessKey;
    @Value("${config.qiniu.secret-key}")
    public String secretKey;
    @Autowired
    private DcAccountingEntryTaskDao dcAccountingEntryTaskDao;

    @Override
    public void uploadToQiniu(String platform, MultipartFile zipFile) throws Exception {
        //构造一个带指定Zone对象的配置类
        Configuration cfg = new Configuration(Region.region2());
        UploadManager uploadManager = new UploadManager(cfg);
        Auth auth = Auth.create(accessKey, secretKey);
        String token = auth.uploadToken("bailun-data-center");
        Response r = uploadManager.put(zipFile.getBytes(), zipFile.getOriginalFilename(), token);
        String domainOfBucket = "http://dcfile.blsct.com";
        String finalUrl = String.format("%s/%s", domainOfBucket, zipFile.getOriginalFilename());
        DcAccountingEntryTask dcAccountingEntryTask = new DcAccountingEntryTask(0, 0, finalUrl, 0, "", LocalDateTime.now(), LocalDateTime.now());
        dcAccountingEntryTaskDao.save(dcAccountingEntryTask);
    }
}
