package com.bailuntec.job;

import com.bailuntec.domain.entity.DcAutoReplaceLogisticsTask;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.example.DcAutoReplaceLogisticsTaskExample;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.mapper.DcAutoReplaceLogisticsTaskMapper;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import org.apache.ibatis.session.SqlSession;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/11/24 4:10 下午
 */
public class ReplaceLogisticJob implements SimpleJob {

    public static ThreadLocal<DcAutoReplaceLogisticsTask> logisticsTaskThreadLocal = new ThreadLocal<>();

    @Override
    public void execute(ShardingContext shardingContext) {

        SqlSession sqlSession = SessionUtil.getFactory().openSession(true);
        try {
            DcAutoReplaceLogisticsTaskMapper dcAutoReplaceLogisticsTaskMapper = sqlSession.getMapper(DcAutoReplaceLogisticsTaskMapper.class);
            DcBaseStockMapper dcBaseStockMapper = sqlSession.getMapper(DcBaseStockMapper.class);

            List<DcAutoReplaceLogisticsTask> dcAutoReplaceLogisticsTaskList = dcAutoReplaceLogisticsTaskMapper.selectByExample(DcAutoReplaceLogisticsTaskExample.newAndCreateCriteria()
                    .andStatusEqualTo(0)
                    .example()
                    .limit(1000));

            dcAutoReplaceLogisticsTaskList.forEach(dcAutoReplaceLogisticsTask -> {
                try {
                    logisticsTaskThreadLocal.set(dcAutoReplaceLogisticsTask);
                    AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();

                    DcBaseStock dcBaseStock = dcBaseStockMapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria()
                            .andBailunSkuEqualTo(dcAutoReplaceLogisticsTask.getBailunSku())
                            .andWarehouseCodeEqualTo(dcAutoReplaceLogisticsTask.getWarehouseCode())
                            .example());

                    autoTurnoverJob.autoTurnoverFromStock(dcBaseStock);
                    dcAutoReplaceLogisticsTask.setStatus(1);
//                    dcAutoReplaceLogisticsTaskMapper.deleteByPrimaryKey(dcAutoReplaceLogisticsTask.getId());
                } catch (Exception ex) {
                    dcAutoReplaceLogisticsTask.setStatus(2);
                } finally {
                    dcAutoReplaceLogisticsTask.setUpdateDate(LocalDateTime.now());
                    dcAutoReplaceLogisticsTaskMapper.updateByPrimaryKeySelective(dcAutoReplaceLogisticsTask);
                    logisticsTaskThreadLocal.remove();
                }
            });
        } finally {
            sqlSession.close();
        }
    }
}
