package com.bailuntec.mapper;

import com.bailuntec.domain.entity.DcAutoSalesForecastStageConfig;
import com.bailuntec.domain.entity.DcAutoTurnover;
import com.bailuntec.domain.entity.DcBaseOmsSku;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 销量预测阶段 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-08-13
 */
public interface DcAutoSalesForecastStageConfigMapper extends BaseMapper<DcAutoSalesForecastStageConfig> {

    /**
     * <p>
     * 查询周转sku命中的规则
     * </p>
     *
     * @param bailunSku     bailunSku
     * @param warehouseCode 仓库编码
     * @return 命中的预测规则
     */
    DcAutoSalesForecastStageConfig selectMatchStage(@Param("bailunSku") String bailunSku,
                                                    @Param("warehouseCode") String warehouseCode,
                                                    @Param("firstOrderDays") Long firstOrderDays,
                                                    @Param("avgOrderCount30") BigDecimal avgOrderCount30,
                                                    @Param("avgOrderCount14") BigDecimal avgOrderCount14,
                                                    @Param("avgOrderCount7") BigDecimal avgOrderCount7);


    /**
     * <p>
     * 根据测试条件查询灰度周转记录
     * </p>
     *
     * @return
     */
    List<DcAutoTurnover> selectTestSyncAutoTurnoverList();

    DcBaseOmsSku firsOrder(@Param("bailunSku") String bailunSku,
                           @Param("warehouseCode") String warehouseCode);

    BigDecimal avgOrderCount(@Param("bailunSku") String bailunSku,
                             @Param("warehouseCode") String warehouseCode,
                             @Param("days") Integer days);
}
