package com.bailuntec.balancesheet.dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
@Data
public class BuyDTO {
    private String no; // 采购计划单号
    private String buyno; //  采购单号
    private Integer buystatus;//采购单状态，-1：作废，0：待确认 1：待出纳审核 2：出纳未付款 3：已付款 4：发货入库中，5：退换货 6：采购完成
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date arrivaldate; // 预计到货日期
    private String warehouseid; // 接收货物仓库
    private String warehousename; // 接收货物仓库名称
    private Integer paycompanyid; // 付款主体
    private String paycompanyname; // '付款主体名称
    private Integer supplierid; // 供应商id
    private String suppliername; // 供应商名称
    private Integer paytype; // 付款类型,1先款后货，2先货后款，3无需付款
    private BigDecimal amount; // 采购总金额
    private BigDecimal payamount; // 实际支付总金额
    private Integer count; // 采购总数量
    private BigDecimal expressfee; // 快递费
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createtime; //` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
    private Integer lastupdateuserid; // 最后操作人id
    private String lastupdateusername; // 最后操作人名称
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date lastupdatetime; // 最后更新时间
    private Integer buyuserid; // 采购员id
    private Integer paystatus; // 付款状态，0：未付款，1：部分付款，2：已付款，3无需付款
    private Integer sendstatus; // 发货状态，0：未发货，1：部分发货，2：全部发货
    private Integer createuserid; // 创建人id
    private String createusername; // 创建人名称
    private String orderno; // 订单号
    private String note; // 采购单备注
    private Integer delstatus; // 是否删除，0：未删除，1：已删除
    private Integer isurgency; // 是否紧急，0：常规，1：紧急
    private String buyusername; //  采购员名称
    private Integer fileid; // 附件id
    private String filepath; // 附件保存路径
    private Integer departmentid; // 部门id
    private String departmentname; // 部门名称
    private Integer audituserid; // 审核人id
    private String auditusername; // 审核人名称
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date audittime; // 审核时间
    private String auditnote; // 审核备注
    private String skucode; // sku 编码
    private String skuname; // sku 标题
    private String company; // 采购主体
    private String supplierNo; // 供应商编号
    private String rejectReason; // 出纳驳回原因
    private String detailKey; // 出纳系统 detailKey
    private String linkLendCostNo; //关联借支单号

    private String supplierBankname; // 供应商银行名称
    private String supplierCardno; // 供应商银行账号
    private String supplierCardusername; // 供应商持卡人
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date payTime; // 付款时间
    private String skuTypeName; // sku 大类标题
    private Integer companyValue; //采购公司主体value
}
