import com.bailuntec.domain.entity.JobAccountLog;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.job.EbayFinanceAdSyncJob;
import com.bailuntec.job.EbayFinanceSyncJob;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
public class EbayFinanceSyncJobTest {

    @Test
    public void test3() {
        EbayFinanceSyncJob skuSyncJob = new EbayFinanceSyncJob();
        ShardingContext job = new ShardingContext(new ShardingContexts("1", "job", 1, "", new HashMap<>()), 0);

        skuSyncJob.executeJob(job, new JobPointLog("", null, 100, 1, 1,
                LocalDateTime.now().minusMonths(1),
                LocalDateTime.now().minusDays(29)));
    }


    @Test
    public void test1() {

        ExecutorService threadPool = Executors.newFixedThreadPool(300);

        //获取时间区间reportDate列表
        List<LocalDateTime> localDateList = Stream.iterate(LocalDateTime.of(2020, 7, 31, 0, 0), localDate -> localDate.plusDays(1))
                .limit(ChronoUnit.DAYS.between(LocalDateTime.of(2020, 7, 31, 0, 0),
                        LocalDateTime.of(2020, 9, 2, 0, 0)) + 1)
                .collect(Collectors.toList());
        localDateList.forEach(localDateTime -> {

            threadPool.execute(() -> {

                EbayFinanceAdSyncJob skuSyncJob = new EbayFinanceAdSyncJob();
                JobAccountLog jobAccountLog = new JobAccountLog();
                jobAccountLog.setAccountId(314);
                jobAccountLog.setStartTime(localDateTime);
                jobAccountLog.setEndTime(localDateTime.plusDays(1));
                jobAccountLog.setIntervalTime(1);
                jobAccountLog.setPageIndex(1);
                jobAccountLog.setPageSize(100);
                skuSyncJob.callSaasApi(jobAccountLog, null);
            });

        });

        threadPool.shutdown();
        try {//等待直到所有任务完成
            threadPool.awaitTermination(Integer.MAX_VALUE, TimeUnit.MINUTES);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }


}
