package com.bailuntec.serviceImpl;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.domain.entity.DcBaseSku;
import com.bailuntec.mapper.BaseSkuMapper;
import com.bailuntec.service.SkuService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.StringUtil;

import java.util.Date;
import java.util.List;

@Service
public class SkuServiceImpl implements SkuService  {
    @Autowired
    private BaseSkuMapper baseSkuMapper;

    @Override
    public PageInfo<DcBaseSku> listSku(JSONObject jsonObject) {
        int pageIndex = jsonObject.getIntValue("pageIndex");
        int pageSize = jsonObject.getIntValue("pageSize") > 1000 ? 1000 :jsonObject.getIntValue("pageSize");
        Date startTime = jsonObject.getDate("startTime");
        Date endTime = jsonObject.getDate("endTime");
        Example example = new Example(DcBaseSku.class);
        example.createCriteria().andBetween("gmtModified", startTime, endTime);
        PageHelper.startPage(pageIndex, pageSize);
        List<DcBaseSku> dcBaseSkus = baseSkuMapper.selectByExample(example);
        PageInfo<DcBaseSku> pageInfo = PageInfo.of(dcBaseSkus);
        return pageInfo;
    }

    @Override
    public PageInfo<DcBaseSku> listSkus(String skus) {
        List<DcBaseSku> dcBaseSkus = null;
        PageInfo<DcBaseSku> pageInfo = null;
        if (StringUtil.isNotEmpty(skus)) {
            dcBaseSkus = baseSkuMapper.listSkuInfo(skus.split(","));
            pageInfo = PageInfo.of(dcBaseSkus);
        }
        return pageInfo;
    }


}
