package com.bailuntec.domain.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 销量预测阶段
 * </p>
 *
 * @author robbendev
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="DcAutoSalesForecastStageConfig对象", description="销量预测阶段")
public class DcAutoSalesForecastStageConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "配置主表id")
    private Integer configId;

    @ApiModelProperty(value = "首次入库距今多少时长（dc_auto_sales_forecast_config.screen_type==1 时生效），0 代表未配置。首次入库取值：dc_base_stock.first_inbound_date")
    private Integer durationUpperLimit;

    @ApiModelProperty(value = "首次入库距今多少时长（dc_auto_sales_forecast_config.screen_type==1 时生效），0 代表未配置。首次入库取值：dc_base_stock.first_inbound_date")
    private Integer durationLowerLimit;

    @ApiModelProperty(value = "销量上限（dc_auto_sales_forecast_config.screen_type==2 时生效），例：10.1，加权日均销量 <= 10.1; dc_auto_turnover.daily_weighted_sales (注意：这个字段正是周转算法要算的不能直接取)")
    private BigDecimal salesUpperLimit;

    @ApiModelProperty(value = "销量下限（dc_auto_sales_forecast_config.screen_type==2 时生效），例：0 加权日均销量 >= 0; dc_auto_turnover.daily_weighted_sales")
    private BigDecimal salesLowerLimit;

    @ApiModelProperty(value = "阶段顺序")
    private Integer index;

    @ApiModelProperty(value = "时间段一的比例，例：0.33 代表 从今天 ~ （供应链长度*0.33）天 的日期全部采用第一时间段的算法；")
    private BigDecimal oneRatio;

    @ApiModelProperty(value = "时间段二的比例")
    private BigDecimal twoRatio;

    @ApiModelProperty(value = "时间段三的比例")
    private BigDecimal threeRatio;

    @ApiModelProperty(value = "时间段一的第一个变量 （过去n1天销量）*（n2）+（过去n3天销量）*（n4）+（过去n5天销量）*（n6）")
    private BigDecimal oneN1;

    @ApiModelProperty(value = "时间段一的第二个变量")
    private BigDecimal oneN2;

    @ApiModelProperty(value = "时间段一的第三个变量 ")
    private BigDecimal oneN3;

    @ApiModelProperty(value = "时间段一的第四个变量 ")
    private BigDecimal oneN4;

    @ApiModelProperty(value = "时间段一的第五个变量 ")
    private BigDecimal oneN5;

    @ApiModelProperty(value = "时间段一的第六个变量 ")
    private BigDecimal oneN6;

    @ApiModelProperty(value = "时间段二的第一个变量 （过去n1天销量）*（n2）+（过去n3天销量）*（n4）+（过去n5天销量）*（n6）")
    private BigDecimal twoN1;

    @ApiModelProperty(value = "时间段二的第二个变量")
    private BigDecimal twoN2;

    @ApiModelProperty(value = "时间段二的第三个变量 ")
    private BigDecimal twoN3;

    @ApiModelProperty(value = "时间段二的第四个变量 ")
    private BigDecimal twoN4;

    @ApiModelProperty(value = "时间段二的第五个变量 ")
    private BigDecimal twoN5;

    @ApiModelProperty(value = "时间段二的第六个变量 ")
    private BigDecimal twoN6;

    @ApiModelProperty(value = "时间段三的第一个变量 （过去n1天销量）*（n2）+（过去n3天销量）*（n4）+（过去n5天销量）*（n6）")
    private BigDecimal threeN1;

    @ApiModelProperty(value = "时间段三的第二个变量")
    private BigDecimal threeN2;

    @ApiModelProperty(value = "时间段三的第三个变量 ")
    private BigDecimal threeN3;

    @ApiModelProperty(value = "时间段三的第四个变量 ")
    private BigDecimal threeN4;

    @ApiModelProperty(value = "时间段三的第五个变量 ")
    private BigDecimal threeN5;

    @ApiModelProperty(value = "时间段三的第六个变量 ")
    private BigDecimal threeN6;


}
