package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.SupplierTransactionDTO;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Repository
public interface DcSupplierTransactionMapper {
    @Insert("<script>" +
            "insert into dc_supplier_transaction(day,types,is_finish,pay_company_value,pay_company_name,supplier_id,supplier_name,parent_supplier_id,parent_supplier_name," +
            "start_amount,putting_amount,express_amount,pay_amount,return_amount,return_express,receive_amount,adjust_amount,end_amount,delay_no_pay_amount) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.day},#{item.types},#{item.isFinish},#{item.payCompanyValue},#{item.payCompanyName},#{item.supplierId},#{item.supplierName}," +
            "#{item.parentSupplierId},#{item.parentSupplierName},#{item.startAmount},#{item.puttingAmount},#{item.expressAmount},#{item.payAmount},#{item.returnAmount}," +
            "#{item.returnExpress},#{item.receiveAmount},#{item.adjustAmount},#{item.endAmount},#{item.delayNoPayAmount})" +
            "</foreach>" +
            "on duplicate key update types=values(types),is_finish=values(is_finish),pay_company_value=values(pay_company_value),pay_company_name=values(pay_company_name)," +
            "supplier_id=values(supplier_id),supplier_name=values(supplier_name),parent_supplier_id=values(parent_supplier_id),parent_supplier_name=values(parent_supplier_name)," +
            "start_amount=values(start_amount),putting_amount=values(putting_amount),express_amount = values(express_amount),pay_amount = values(pay_amount)," +
            "return_amount = values(return_amount),return_express = values(return_express),receive_amount = values(receive_amount),adjust_amount = values(adjust_amount)," +
            "end_amount = values(end_amount),delay_no_pay_amount = values(delay_no_pay_amount)" +
            "</script>")
    void insertOrUpdateSupplierTransaction(List<SupplierTransactionDTO> supplierTransactionDTOList);

    /**
     * 应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount > 0 and types = 2")
    BigDecimal getAccountsPayableSum(@Param("lastDay") Date lastDay);

    /**
     * 预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount < 0 and types = 2")
    BigDecimal getPrepaymentSum(@Param("lastDay") Date lastDay);

    /**
     * 成品应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount > 0 and is_finish = 1 and types = 2")
    BigDecimal getFinishedAccountsPayableSum(@Param("lastDay") Date lastDay);

    @Select("select sum(amount_end) from dc_daily_receivable where day = #{lastDay}")
    BigDecimal getAccountsReceivable(@Param("lastDay") Date lastDay);

    /**
     * 成品预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount < 0 and is_finish = 1 and types = 2")
    BigDecimal getFinishedPrepaymentSum(@Param("lastDay") Date lastDay);

    /**
     * 半成品应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount > 0 and is_finish = 0 and types = 2")
    BigDecimal getSemiAccountsPayableSum(@Param("lastDay") Date lastDay);

    /**
     * 半成品预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_supplier_transaction where day = #{lastDay} and end_amount < 0 and is_finish = 0 and types = 2")
    BigDecimal getSemiPrepaymentSum(@Param("lastDay") Date lastDay);

}
