package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.SemiStockLogDTO;
import com.bailuntec.balancesheet.dto.SemiSupOfferLogDTO;
import org.apache.ibatis.annotations.Insert;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DcSemiStockLogMapper {
    @Insert("<script>" +
            "insert into dc_semi_stock_log(log_id,sku_code,sku_name,log_type_id,log_type,log_quantity,final_stock,warehouse_id,warehouse_name,create_time," +
            "redundancy_stock,warehouse_type,type_id,type_name,product_category_id,product_category_name) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.logId},#{item.skuCode},#{item.skuName},#{item.logTypeId},#{item.logType},#{item.logQuantity},#{item.finalStock},#{item.warehouseId},#{item.warehouseName}," +
            "#{item.createTime},#{item.redundancyStock},#{item.warehouseType})" +
            "</foreach>" +
            " on duplicate key update log_id=values(log_id),sku_name=values(sku_name),log_type_id=values(log_type_id),log_type=values(log_type),log_quantity=values(log_quantity)," +
            "final_stock=values(final_stock),warehouse_id=values(warehouse_id),warehouse_name=values(warehouse_name),create_time=values(create_time)," +
            "redundancy_stock=values(redundancy_stock),warehouse_type=values(warehouse_type),type_id=#{typeId},type_name=#{typeName}" +
            ",product_category_id=#{productCategoryId},product_category_name=#{productCategoryName}" +
            "</script>")
    void insertOrUpdateSemiStockLog(List<SemiStockLogDTO> semiStockLogDTOList);
}
