package com.bailuntec.job;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.constant.Constant;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import org.junit.jupiter.api.Test;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/2/25 10:02 上午
 */

public class QueueConsumerJobTest {

    @Test
    public void test() {
//        ShardingContext shardingContext = new ShardingContext(new ShardingContexts("x", null, 1, Constant.AIR_HEAD, new HashMap<>()), 0);
//        AutoTurnoverJob.shardingContextThreadLocal.set(shardingContext);
        QueueConsumerJob.BaseQueueMessage baseQueueMessage = new QueueConsumerJob.BaseQueueMessage();
        baseQueueMessage.setBailunSku("LM-EO-007");
        baseQueueMessage.setWarehouseCode("MMDUSFBA");

        DcBaseStockMapper dcBaseStockMapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();

        DcBaseStock dcBaseStock = dcBaseStockMapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria()
                .andBailunSkuEqualTo(baseQueueMessage.getBailunSku())
                .andWarehouseCodeEqualTo(baseQueueMessage.getWarehouseCode())
                .example());

//        autoTurnoverJob.autoTurnoverFromStock(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now()), dcBaseStock);
//        AutoTurnoverJob.shardingContextThreadLocal.set(new ShardingContext(new ShardingContexts("x", null, 1, Constant.OCEAN_HEAD, new HashMap<>(16)), 0));
//        autoTurnoverJob.autoTurnoverFromStock(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now()), dcBaseStock);
//        AutoTurnoverJob.shardingContextThreadLocal.remove();
        AutoTurnoverJob.shardingContextThreadLocal.set(new ShardingContext(new ShardingContexts("x", null, 1, Constant.OCEAN_HEAD, new HashMap<>(16)), 0));
        autoTurnoverJob.autoTurnoverFromStock(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now()), dcBaseStock);
        AutoTurnoverJob.shardingContextThreadLocal.remove();


    }

}
