package com.bailuntec.domain.constant;

import com.google.common.collect.Lists;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public interface Constant {
    /**
     * 配置最少预测多少天
     */
    Integer MIN_AUTO_FORECAST_DAY = 31;
    /**
     * 质检天数
     */
    Integer INSPECTION_DELIVE = 2;
    /**
     * 周转倍数
     */
    Integer TURNOVER_MULTIPLE = 2;
    String ALGORITHM_NAME = "算法预测";
    String NAN_STRING = "N/A";
    String PURCHASE_SIGN = "p_";
    String TRANSFER_SIGN = "t_";

    /**
     * 自动周转JIT的 可以不做 冗余 和 缺货预测 实际冗余和实际缺货也不用提醒 这三个采购都是美甲和精油的, 都是JIT的
     */
    String BUYER_JIT_1 = "张莹霞";
    String BUYER_JIT_2 = "张莹霞1";
    String BUYER_JIT_3 = "冯兆欣";

    /**
     * JIT三兄弟!
     */
    List<String> BUYER_JIT_123 = Lists.newArrayList(BUYER_JIT_1, BUYER_JIT_2, BUYER_JIT_3);

    String BUYER_JIT_4 = "黄镜洁";
    String BUTER_JIT_5 = "赵美聪";
    String WAREHOUSE_JIT = "GZBLWH";
    String WAREHOUSE_JIT1 = "BLGZ03";
    BigDecimal BIGDECIMAL_THIRTY = BigDecimal.valueOf(30);
    BigDecimal BIGDECIMAL_FOURTEEN = BigDecimal.valueOf(14);
    BigDecimal BIGDECIMAL_SEVEN = BigDecimal.valueOf(7);
    BigDecimal BIGDECIMAL_THREE = BigDecimal.valueOf(3);

    /**
     * 0.93 = 1 - 0.07, 来自老板提的FBA断货, 销量递减
     */
    BigDecimal FBA_OUT_STOCK_DECREASE = BigDecimal.valueOf(0.93);

    /**
     * 0.93 = 1 - 0.07, 来自老板提的FBA断货, 销量递减
     */
    BigDecimal FBA_OUT_STOCK_INCREMENT = BigDecimal.valueOf(1.07);
    LocalDateTime INIT_DATE_TIME = LocalDateTime.of(1990, 1, 1, 0, 0);


    String OCEAN_HEAD = "海运头程";
    String AIR_HEAD = "空运头程";

}
