package com.bailuntec.listener;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcAutoException;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.example.DcAutoExceptionExample;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.job.AutoTurnoverJob;
import com.bailuntec.mapper.DcAutoExceptionMapper;
import com.bailuntec.mapper.DcAutoTurnoverMapper;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Slf4j
public class AutoTurnoverJobListener implements ElasticJobListener {
    @Override
    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        try {
            DcAutoTurnoverMapper autoTurnoverMapper = SessionUtil.getSession().getMapper(DcAutoTurnoverMapper.class);
            autoTurnoverMapper.truncateAutoInboundTable();
            autoTurnoverMapper.truncateAutoInventoryTable();
            autoTurnoverMapper.truncateAutoShortSupplyTable();
            autoTurnoverMapper.truncateAutoTurnoverTable();
            autoTurnoverMapper.truncateAutoSalesTable();
            autoTurnoverMapper.truncateAutoExceptionTable();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Mybatis操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }

    @Override
    public void afterJobExecuted(ShardingContexts shardingContexts) {
        String queryTime = DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now());
        int pageIndex = 0;
        int pageSize = 1000;
        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        List<DcAutoException> dcAutoExceptions = null;

        SqlSession sqlSession = SessionUtil.getFactory().openSession(true);
        try {
            DcAutoExceptionMapper mapper = sqlSession.getMapper(DcAutoExceptionMapper.class);
            DcBaseStockMapper dcBaseStockMapper = sqlSession.getMapper(DcBaseStockMapper.class);
            do {
                dcAutoExceptions = mapper.selectByExample(DcAutoExceptionExample.newAndCreateCriteria().example().limit(pageIndex * pageSize, pageSize));
                if (dcAutoExceptions != null && dcAutoExceptions.size() >0) {
                    for (DcAutoException dcAutoException : dcAutoExceptions) {
                        DcBaseStock dcBaseStock = dcBaseStockMapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria().andBailunSkuEqualTo(dcAutoException.getBailunSku()).andWarehouseCodeEqualTo(dcAutoException.getWarehouseCode()).example());
                        try {
                            autoTurnoverJob.autoTurnoverFromStock(queryTime, dcBaseStock);
                        } catch (Exception e) {
                            log.error("Mybatis操作自动周转异常数据再次计算失败SKU=" + dcAutoException.getBailunSku() + ",仓库编码=" + dcAutoException.getWarehouseCode());
                        }
                        mapper.deleteByPrimaryKey(dcAutoException.getId());
                    }
                }
                pageIndex++;
            } while (dcAutoExceptions != null && dcAutoExceptions.size() == pageSize);
        } catch (RuntimeException e) {
            throw new RuntimeException("Mybatis操作自动周转异常数据再次计算失败");
        } finally {
           if (sqlSession != null) {
               sqlSession.close();
           }
        }
    }
}
