package com.bailuntec.job;

import com.alibaba.excel.EasyExcel;
import com.bailuntec.domain.entity.DcBaseCompanyAccount;
import com.bailuntec.domain.entity.DcBaseFinanceEbay;
import com.bailuntec.domain.example.DcBaseCompanyAccountExample;
import com.bailuntec.domain.example.DcBaseFinanceEbayExample;
import com.bailuntec.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.mapper.DcBaseFinanceEbayMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/9/14 9:41 上午
 */
@Slf4j
public class EbayFinanceAdSyncJobTest {

    @Test
    public void executeJob() {
        PointJob ebayFinanceAdSyncJob = new EbayFinanceAdSyncJob();
        ShardingContext shardingContext = new ShardingContext(
                new ShardingContexts("x", "base-sync-finance-ebay-ad", 1, null, new HashMap<>()), 0
        );

        ebayFinanceAdSyncJob.execute(shardingContext);
    }

    @org.junit.Test
    public void exportSku() {
        DcBaseFinanceEbayMapper dcBaseFinanceEbayMapper = SessionUtil.getSession().getMapper(DcBaseFinanceEbayMapper.class);
        DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper = SessionUtil.getSession().getMapper(DcBaseCompanyAccountMapper.class);

        Map<Integer, DcBaseCompanyAccount> map = dcBaseCompanyAccountMapper.selectByExample(DcBaseCompanyAccountExample.newAndCreateCriteria()
                .example())
                .stream()
                .collect(Collectors.toMap(DcBaseCompanyAccount::getAccountId, dcBaseCompanyAccount -> dcBaseCompanyAccount, (k1, k2) -> k1));


        List<DcBaseFinanceEbay> dcBaseFinanceEbayList = dcBaseFinanceEbayMapper.selectByExample(DcBaseFinanceEbayExample.newAndCreateCriteria()
//                .andAccountIdEqualTo(314)
                .andBjDateBetween(LocalDateTime.of(2020, 9, 1, 0, 0),
                        LocalDateTime.of(2020, 10, 1, 0, 0))
                .example());

        List<EbayFinanceExport> ebayFinanceExportList = dcBaseFinanceEbayList.stream()
                .map(dcBaseFinanceEbay -> {
                    EbayFinanceExport ebayFinanceExport = new EbayFinanceExport();

                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

                    ebayFinanceExport.setBjDate(df.format(dcBaseFinanceEbay.getBjDate()));
                    ebayFinanceExport.setCurrency(dcBaseFinanceEbay.getCurrency());
                    ebayFinanceExport.setDescription(dcBaseFinanceEbay.getDescription());
                    ebayFinanceExport.setGrossAmount(dcBaseFinanceEbay.getGrossAmount());
                    ebayFinanceExport.setTitle(dcBaseFinanceEbay.getTitle());
                    ebayFinanceExport.setAccountName(map.get(dcBaseFinanceEbay.getAccountId()).getAccountName());
                    return ebayFinanceExport;
                })
                .collect(Collectors.toList());
        EasyExcel.write("/Users/huluobin/exportEbay202009-2020-10-26.xlsx", EbayFinanceExport.class).sheet().doWrite(ebayFinanceExportList);
    }

    @Test
    public void testThreadPool() {
        EbayFinanceAdSyncJob ebayFinanceAdSyncJob = new EbayFinanceAdSyncJob();
        ShardingContext shardingContext = new ShardingContext(
                new ShardingContexts("x", "base-sync-finance-ebay-ad", 1, null, new HashMap<>()), 0
        );

        ebayFinanceAdSyncJob.executeJob(shardingContext, null);

    }
}
