import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.pojo.OmsResultInfo;
import com.bailuntec.domain.pojo.OmsResultRoot;
import com.bailuntec.job.OrderSyncJob;
import com.bailuntec.utils.OkHttpUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;

public class OmsOrderTest {


    @Test
    public void test1() {
        OkHttpClient okHttpClient = OkHttpUtil.getInstance();
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("pageIndex", "239");
        map.put("pageCount", "100");
        map.put("BailunLastUpdateTimeFrom", "2019-04-11 11:45:33");
        map.put("BailunLastUpdateTimeTo", "2019-04-11 16:17:03");
        Request request = new Request.Builder()
                .get()
                .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String omsResultStr = null;
        try {
            response = okHttpClient.newCall(request).execute();
            omsResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        if (StringUtils.isNoneBlank(omsResultStr)) {
            OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
            if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                    orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                }
            } else {
                throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
            }
        }
    }

    @Test
    public void test4() {
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(0);
        jobPointLog.setPageSize(100);
        jobPointLog.setStartTime(LocalDateTime.of(2020, 8, 1, 0, 0));
        jobPointLog.setEndTime(LocalDateTime.of(2020, 9, 3, 0, 0));
        jobPointLog.setIntervalTime(1);
        orderSyncJob.executeJob(null, jobPointLog);
    }

    @Test
    public void test() {
        OkHttpClient okHttpClient = OkHttpUtil.getInstance();
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("pageIndex", "1");
        map.put("pageCount", "100");
        map.put("OriginOrderNo", "402-0458942-3060306");
        Request request = new Request.Builder()
                .get()
                .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String omsResultStr = null;
        try {
            response = okHttpClient.newCall(request).execute();
            omsResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        if (StringUtils.isNoneBlank(omsResultStr)) {
            OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
            if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                    orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                }
            } else {
                throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
            }
        }
    }
}
