package com.bailuntec.job;

import com.bailuntec.domain.pojo.AmazonAdProduct;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.junit.jupiter.api.Test;

import java.io.*;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/19 11:39 上午
 */
@Slf4j
class AmazonAdDownloadReportJobTest {

    @Test
    void execute() {
        AmazonAdDownloadReportJob amazonAdDownloadReportJob = new AmazonAdDownloadReportJob();
        amazonAdDownloadReportJob.execute(new ShardingContext(new ShardingContexts("x", null, 1, null, new HashMap<>()), 0));
    }

    @Test
    public void downloadReport() throws IOException {
        Request request = new Request.Builder()
                .url("https://advertising-api-eu.amazon.com/v1/reports/amzn1.clicksAPI.v1.p35691.5F3CB79F.8b7bf3b1-49f4-42f5-aee3-948215758208/download/")
                .get()
                .addHeader("Authorization", "Atza|IwEBIECxu5mURTbJo6LfkoB9et_xNpwUemnh7Nav426JfaTwoBQYhhXzn7SzrQDLBYTz0HEYlaCQeJp4okJbRvESaovFWbzP8Hg3poV4x9_YfteilpM0WHvtYoJbZj6BGK2WcAZyncZ1qgSoTHnTPzZuMyniev8BmcEO9UZTfOULeXN86Z7Anyq6Ta_XwA8m4sPUPftUg2Fz-9O6Hm618Z9TDxDdImf4TKyRSr9PXc75XIS_ACrKlK-MjU4ILI1qYgeckI1xpns69MmPJ5G2SvXqQBKSt1CJYq-ZfAqf4-e659SYkieyODjo3qXCyDQ7B9B4LGYxzut0L-WN9SQZO9keBwPtLFPK2StaYpk85F-QIAog6LR3RIdMhzl2Wh-H_JvY4MBEVD3z7HLUfTlFeQVCVuHONgCaBnMurNj6F5VtJ49oQ8J3qxzZx8Il1Jnli5D7cQU99h1MOqmIVk5Q_P-4hqiWVnCwydA9c0G-zho_bR_-bQ")
                .addHeader("Amazon-Advertising-API-ClientId", "amzn1.application-oa2-client.a68a22f3f5e44a5691e5780f1b31014c")
                .addHeader("Amazon-Advertising-API-Scope", "596170210050198")
                .addHeader("Content-Type", "application/json")
                .build();

        Response response = new OkHttpClient().newCall(request).execute();

//        File file = new File("/Users/huluobin/Downloads/adProfile")

        GZIPInputStream inputStream = new GZIPInputStream(response.body().byteStream());
        Type type = new TypeToken<List<AmazonAdProduct>>() {
        }.getType();



        StringBuilder html= new StringBuilder();

        Scanner sc = new Scanner(inputStream);
        while (sc.hasNextLine()) {
            html.append(sc.nextLine().toString() + "\r\n");
        }

        System.out.println(html);


    }

}
