import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.job.AutoTurnoverJob;
import com.bailuntec.listener.AutoTurnoverJobListener;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import org.junit.jupiter.api.Test;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;

public class AutoTurnoverTest {
//    @Test
    public void test1() throws Exception {
        LocalDate parse = LocalDate.parse("2018-01-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate parse1 = LocalDate.parse("2018-01-02", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        System.out.println(parse.isBefore(parse1));
        System.out.println(parse.isAfter(parse1));
        System.out.println(parse.isEqual(parse1));
        if (parse.isBefore(parse1)) {
            System.out.println(parse.compareTo(parse1));
        }
    }
    @Test
    public void test12() throws Exception {
        System.out.println(LocalDateTime.of(1990,1,1,0,0));
    }
    @Test
    public void test10() throws Exception {
        int interval = Period.between(LocalDate.now().minusDays(1), LocalDate.now()).getDays();
        int interval1 = Period.between(LocalDate.now(), LocalDate.now().minusDays(2)).getDays();
        int interval2 = Period.between(LocalDate.now(), LocalDate.now()).getDays();
        System.out.println(interval);
        System.out.println(interval1);
        System.out.println(interval2);
    }
    @Test
    public void test() throws Exception {
        String queryTime = DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now());
        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        DcBaseStock dcBaseStock = null;
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
//            dcBaseStock = mapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria().andBailunSkuEqualTo("322572421").andWarehouseCodeEqualTo("QYBLZZ").example());
//            dcBaseStock = mapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria().andBailunSkuEqualTo("232232601").andWarehouseCodeEqualTo("CHUKFBA").example());
//            dcBaseStock = mapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria().andBailunSkuEqualTo("213789601").andWarehouseCodeEqualTo("GZBLWH").example());
            dcBaseStock = mapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria().andBailunSkuEqualTo("273502105").andWarehouseCodeEqualTo("GZBLWH").example());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
        autoTurnoverJob.autoTurnoverFromStock(queryTime, dcBaseStock);
    }

    @Test
    public void test22() throws Exception {
        String queryTime = DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now());
        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        List<DcBaseStock> dcBaseStockList = null;
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            dcBaseStockList = mapper.listInStockNotInAutoTurnover();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
        for (DcBaseStock dcBaseStock : dcBaseStockList) {
            autoTurnoverJob.autoTurnoverFromStock(queryTime, dcBaseStock);
        }
    }
    @Test
    public void test3() throws Exception {
        String queryTime = DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now());
        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        List<DcBaseStock> dcBaseStockList = null;
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            dcBaseStockList = mapper.selectByExample(DcBaseStockExample.newAndCreateCriteria().example());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
        for (DcBaseStock dcBaseStock : dcBaseStockList) {
            autoTurnoverJob.autoTurnoverFromStock(queryTime, dcBaseStock);
        }
    }
    @Test
    public void test4()  {
        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();
        HashMap<Integer, String> map = new HashMap<>();
        map.put(1,"");
        ShardingContext shardingContext = new ShardingContext(new ShardingContexts("","",4,"", map), 3);
        JobPointLog jobPointLog = new JobPointLog("", 1, 2000, 1, 1, LocalDateTime.now().minusSeconds(1), LocalDateTime.now());
        autoTurnoverJob.executeJob(shardingContext, jobPointLog);
    }

    @Test
    public void test5()  {
        AutoTurnoverJobListener autoTurnoverJobListener = new AutoTurnoverJobListener();
        autoTurnoverJobListener.afterJobExecuted(null);
    }
    @Test
    public void test55()  {
        LocalDateTime recordTime = LocalDateTime.now();
        LocalDateTime finalEstimatedArrivalTime = LocalDateTime.now().minusDays(1);
        int interval = Period.between(recordTime.toLocalDate(), finalEstimatedArrivalTime.toLocalDate()).getDays();
        System.out.println(interval);
    }
    @Test
    public void test66()  {

    }

}
