package com.bailuntec.job;

import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import java.io.IOException;

@Slf4j
public class SkuWarehouseSalesJob implements SimpleJob {
    private OkHttpClient client = OkHttpUtil.getInstance();
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    @Override
    public void execute(ShardingContext shardingContext) {
        RequestBody requestBody = RequestBody.create(null, new byte[]{});
        Request request = new Request.Builder().url(propertiesUtil.getPropertyAsString("SKUWAREHOUSESALES_URL"))
                .post(requestBody)
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        } catch (IOException e) {
            throw new RuntimeException("调用SkuWarehouseSales接口失败", e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }
}
