package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.entity.DcBalanceSheet;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;
@Repository
public interface DcBalanceSheetMapper {

    @Insert("insert into dc_balance_sheet(company_value,company_name,statistical_time) values (#{companyValue},#{companyName},#{lastDay})")
    Integer insertBalanceSheet(@Param("companyValue") Integer companyValue, @Param("companyName") String companyName, @Param("lastDay") Date lastDay);

    @Select("select * from dc_balance_sheet where statistical_time = #{lastDay} and company_value = #{companyValue} and company_name = #{companyName} limit 1")
    DcBalanceSheet getDcBalanceSheetInit(@Param("companyValue") Integer companyValue, @Param("companyName") String companyName, @Param("lastDay") Date lastDay);
    /**
     * 短期借款均属于广州百伦
     * @param shortTermBorrow
     * @param date
     */
    @Update("update dc_balance_sheet set short_term_borrow = #{shortTermBorrow} where company_value = 1 and statistical_time = #{date}")
    void updateShortTermBorrow(@Param("shortTermBorrow") BigDecimal shortTermBorrow, @Param("date") Date date);

    /**
     * 插入新的广州百伦资产负债表
     * 以下项默认取前一天的数据
     *      应收账款、存货、长期股权投资、固定资产、无形资产、长期待摊费用、应付账款、应付职工薪酬、应交税费、长期应付款、实收资本、资本公积、未分配利润
     * @param lastDay
     * @param twoDaysBefore
     */
    @Select("insert into dc_balance_sheet(statistical_time,company_value,company_name,accounts_receivable,inventory_amount,nca_longterm_equity_investment,fixed_assets," +
            "nca_intangible_assets,nca_longterm_unamortized_expenses,accounts_payable,payable_remuneration,taxes_payable,long_term_accounts_payable,oe_paicl_up_capital," +
            "oe_capital_reserve,oe_undistributed_profit) " +
            "select #{lastDay},company_value,company_name,accounts_receivable,inventory_amount,nca_longterm_equity_investment,fixed_assets," +
            "nca_intangible_assets,nca_longterm_unamortized_expenses,accounts_payable,payable_remuneration," +
            "taxes_payable,long_term_accounts_payable,oe_paicl_up_capital,oe_capital_reserve,oe_undistributed_profit " +
            "from dc_balance_sheet where company_value = 1 and statistical_time = #{twoDaysBefore}")
    void insertGzBailunBalanceSheet(@Param("lastDay") Date lastDay, @Param("twoDaysBefore") Date twoDaysBefore);

    /**
     * 更新广州百伦资产负债表，以下项默认取前一天的数据：
     *      应收账款、存货、长期股权投资、固定资产、无形资产、长期待摊费用、应付账款、应付职工薪酬、应交税费、长期应付款、实收资本、资本公积、未分配利润
     * @param lastDay
     * @param twoDaysBefore
     */
    @Select("update dc_balance_sheet a inner join " +
            "(select company_value,accounts_receivable,inventory_amount,nca_longterm_equity_investment,fixed_assets," +
            "nca_intangible_assets,nca_longterm_unamortized_expenses,accounts_payable,payable_remuneration," +
            "taxes_payable,long_term_accounts_payable,oe_paicl_up_capital,oe_capital_reserve,oe_undistributed_profit " +
            "from dc_balance_sheet where company_value = 1 and statistical_time = #{twoDaysBefore}) b " +
            "on a.company_value = b.company_value " +
            "set a.accounts_receivable = b.accounts_receivable," +
            "a.inventory_amount = b.inventory_amount," +
            "a.nca_longterm_equity_investment = b.nca_longterm_equity_investment," +
            "a.fixed_assets = b.fixed_assets," +
            "a.nca_intangible_assets = b.nca_intangible_assets," +
            "a.nca_longterm_unamortized_expenses = b.nca_longterm_unamortized_expenses," +
            "a.accounts_payable = b.accounts_payable," +
            "a.payable_remuneration = b.payable_remuneration," +
            "a.taxes_payable = b.taxes_payable," +
            "a.long_term_accounts_payable = b.long_term_accounts_payable," +
            "a.oe_paicl_up_capital = b.oe_paicl_up_capital," +
            "a.oe_capital_reserve = b.oe_capital_reserve," +
            "a.oe_undistributed_profit = b.oe_undistributed_profit " +
            "where a.company_value = 1 and a.statistical_time = #{lastDay}")
    void updateGzBailunBalanceSheet(@Param("lastDay") Date lastDay, @Param("twoDaysBefore") Date twoDaysBefore);

    /**
     * 插入新的香港百伦资产负债表
     * 以下项默认取前一天的数据
     *      长期股权投资、固定资产、递延所得税资产、实收资本、资本公积、未分配利润
     * @param lastDay
     * @param twoDaysBefore
     */
    @Select("insert into dc_balance_sheet(statistical_time,company_value,company_name,nca_longterm_equity_investment," +
            "fixed_assets,nca_deferred_tax_assets,oe_paicl_up_capital,oe_capital_reserve,oe_undistributed_profit) " +
            "select #{lastDay},company_value,company_name,nca_longterm_equity_investment,fixed_assets,nca_deferred_tax_assets," +
            "oe_paicl_up_capital,oe_capital_reserve,oe_undistributed_profit " +
            "from dc_balance_sheet where company_value = 2 and statistical_time = #{twoDaysBefore}")
    void insertHkBailunBalanceSheet(@Param("lastDay") Date lastDay, @Param("twoDaysBefore") Date twoDaysBefore);

    /**
     * 更新香港百伦资产负债表，以下项默认取前一天的数据：
     *      长期股权投资、固定资产、递延所得税资产、实收资本、资本公积、未分配利润
     * @param lastDay
     * @param twoDaysBefore
     */
    @Update("update dc_balance_sheet a inner join " +
            "(select company_value,nca_longterm_equity_investment,fixed_assets,nca_deferred_tax_assets," +
            "oe_paicl_up_capital,oe_capital_reserve,oe_undistributed_profit " +
            "from dc_balance_sheet where company_value = 2 and statistical_time = #{twoDaysBefore}) b " +
            "on a.company_value = b.company_value " +
            "set a.nca_longterm_equity_investment = b.nca_longterm_equity_investment," +
            "a.fixed_assets = b.fixed_assets," +
            "a.nca_deferred_tax_assets = b.nca_deferred_tax_assets," +
            "a.oe_paicl_up_capital = b.oe_paicl_up_capital," +
            "a.oe_capital_reserve = b.oe_capital_reserve," +
            "a.oe_undistributed_profit = b.oe_undistributed_profit " +
            "where a.company_value = 2 and a.statistical_time = #{lastDay}")
    void updateHkBailunBalanceSheet(@Param("lastDay") Date lastDay, @Param("twoDaysBefore") Date twoDaysBefore);

    int updateByCompanyAndDaySelective(DcBalanceSheet dcBalanceSheet);


    @Insert({
        "insert into dc_balance_sheet (id, company_value, ",
        "company_name, monetary_fund, ",
        "accounts_receivable, prepayment, ",
        "other_accounts_receivable, inventory_amount, ",
        "fixed_assets, short_term_borrow, ",
        "accounts_payable, advance_received, ",
        "payable_remuneration, taxes_payable, ",
        "other_accounts_payable, long_term_accounts_payable, ",
        "statistical_time, update_time)",
        "values (#{id,jdbcType=INTEGER}, #{companyValue,jdbcType=INTEGER}, ",
        "#{companyName,jdbcType=VARCHAR}, #{monetaryFund,jdbcType=DECIMAL}, ",
        "#{accountsReceivable,jdbcType=DECIMAL}, #{prepayment,jdbcType=DECIMAL}, ",
        "#{otherAccountsReceivable,jdbcType=DECIMAL}, #{inventoryAmount,jdbcType=DECIMAL}, ",
        "#{fixedAssets,jdbcType=DECIMAL}, #{shortTermBorrow,jdbcType=DECIMAL}, ",
        "#{accountsPayable,jdbcType=DECIMAL}, #{advanceReceived,jdbcType=DECIMAL}, ",
        "#{payableRemuneration,jdbcType=DECIMAL}, #{taxesPayable,jdbcType=DECIMAL}, ",
        "#{otherAccountsPayable,jdbcType=DECIMAL}, #{longTermAccountsPayable,jdbcType=DECIMAL}, ",
        "#{statisticalTime,jdbcType=DATE}, #{updateTime,jdbcType=TIMESTAMP})"
    })
    int insert(DcBalanceSheet record);

    int insertSelective(DcBalanceSheet record);

    @Select({
        "select",
        "id, company_value, company_name, monetary_fund, accounts_receivable, prepayment, ",
        "other_accounts_receivable, inventory_amount, fixed_assets, short_term_borrow, ",
        "accounts_payable, advance_received, payable_remuneration, taxes_payable, other_accounts_payable, ",
        "long_term_accounts_payable, statistical_time, update_time",
        "from dc_balance_sheet",
        "where id = #{id,jdbcType=INTEGER}"
    })
    @ResultMap("com.bailuntec.balancesheet.mapper.DcBalanceSheetMapper.BaseResultMap")
    DcBalanceSheet selectByPrimaryKey(Integer id);

    @Select({"select logistics_accounts_payable from dc_balance_sheet where statistical_time = #{date}"})
    BigDecimal getLogisticsAccountsPayableInit(@Param("date") Date date);

    @Select({"select finished_accounts_payable from dc_balance_sheet where statistical_time = #{date}"})
    BigDecimal getLogisticsAccountsPayableSum(@Param("date") Date date);

    @Select("select finished_accounts_payable from dc_balance_sheet where statistical_time <= #{lastDay} and finished_accounts_payable > 0 order by finished_accounts_payable desc limit 1 ")
    BigDecimal getLogisticsAccountsPayableSumByOld(@Param("date") Date date);

    @Select("select sum((amount - ifnull(had_pay, 0) + ifnull(compensate, 0)) * to_rmb_rate) from dc_daily_fee where recoed_time = #{lastDay} and company_value in (53,3,5,60,66,59,50,8,1,61,2)")
    BigDecimal getAmountBorrowed(@Param("lastDay") Date lastDay);

    @Select("select accounts_receivable_import from dc_balance_sheet where statistical_time = #{lastDay} ")
    BigDecimal getAccountsReceivableImport(@Param("lastDay") Date lastDay);

    @Select("select finished_accounts_payable from dc_balance_sheet where statistical_time <= #{lastDay} and finished_accounts_payable > 0 order by finished_accounts_payable desc limit 1 ")
    BigDecimal getFinashedAccountSumByOld(@Param("lastDay") Date lastDay);

    @Select("select accounts_receivable_update from dc_balance_sheet where statistical_time = #{lastDay} ")
    BigDecimal getAccountsReceivableUpdate(@Param("lastDay") Date lastDay);

    @Select("select platform_balance from dc_balance_sheet where statistical_time = #{lastDay}")
    BigDecimal getPlatformBalanceUpdate(@Param("lastDay") Date lastDay);

    @Select("select platform_balance from dc_balance_sheet where statistical_time <= #{lastDay} and platform_balance > 0 order by statistical_time desc limit 1")
    BigDecimal getPlatformBalanceSum(@Param("lastDay") Date lastDay);

    @Select("select other_accounts_receivable_import from dc_balance_sheet where statistical_time = #{lastDay}")
    BigDecimal getOtherAccountsReceivableImport(@Param("lastDay") Date lastDay);

    @Select("select other_accounts_receivable_import from dc_balance_sheet where statistical_time = #{lastDay}")
    BigDecimal getFixedAssetsImport(@Param("lastDay") Date lastDay);

    int updateByPrimaryKeySelective(DcBalanceSheet record);

    @Update({
        "update dc_balance_sheet",
        "set company_value = #{companyValue,jdbcType=INTEGER},",
          "company_name = #{companyName,jdbcType=VARCHAR},",
          "monetary_fund = #{monetaryFund,jdbcType=DECIMAL},",
          "accounts_receivable = #{accountsReceivable,jdbcType=DECIMAL},",
          "prepayment = #{prepayment,jdbcType=DECIMAL},",
          "other_accounts_receivable = #{otherAccountsReceivable,jdbcType=DECIMAL},",
          "inventory_amount = #{inventoryAmount,jdbcType=DECIMAL},",
          "fixed_assets = #{fixedAssets,jdbcType=DECIMAL},",
          "short_term_borrow = #{shortTermBorrow,jdbcType=DECIMAL},",
          "accounts_payable = #{accountsPayable,jdbcType=DECIMAL},",
          "advance_received = #{advanceReceived,jdbcType=DECIMAL},",
          "payable_remuneration = #{payableRemuneration,jdbcType=DECIMAL},",
          "taxes_payable = #{taxesPayable,jdbcType=DECIMAL},",
          "other_accounts_payable = #{otherAccountsPayable,jdbcType=DECIMAL},",
          "long_term_accounts_payable = #{longTermAccountsPayable,jdbcType=DECIMAL},",
          "statistical_time = #{statisticalTime,jdbcType=DATE},",
          "update_time = #{updateTime,jdbcType=TIMESTAMP}",
        "where id = #{id,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(DcBalanceSheet record);
}