## 数据中心

### 解释说明
抛弃臃肿的框架, 轻量级的数据处理中心. 

因为不同的任务, 执行频率,资源占用情况不一样, 需要能够对任务进行灵活的分配, 任务之间最好不要互相影响, 保持独立性.

### 环境依赖
| 项目名                     | 技术栈  |
| ---                        | ---- |
| data-api                  | springboot, tkmapper, pageHelper    |
| data-base                 | zookeeper, okhttp, logback, druid, elastic-job-lite, fastjson    |
| data-mid                  | zookeeper, okhttp, logback, druid, elastic-job-lite, fastjson    |
| data-show                 | zookeeper, okhttp, logback, druid, elastic-job-lite, fastjson     |
| elastic-job-lite          | elastic-job, jetty   |
| mybatis-generator         | mybatis-generator   |

### 项目目录
```
| README.md     
| .gitignore                            Git提交忽略文件
| mybatis-generator                     MYBATIS代码生成工具, 修改了原版的Jar依赖
| elastic-job-lite                      分布式任务调度
| data-api                              对外提供Http接口
| data-common                           公共模块,一些工具类和共用的实体
| data-parent                           依赖统一管理
    |-data-base                         基础数据对接
        |-base-sync-cost-first          同步物流头程费用
        |-base-sync-crm-refund          同步CRM系统退款
        |-base-sync-oms-order           同步OMS系统订单
        |-base-sync-oms-order-for-tj    为TJ系统写的同步OMS系统订单(已废弃)
        |-base-sync-purchase            同步采购系统流水
        |-base-sync-purchase-details    同步采购系统详情
        |-base-sync-sku                 同步SKUMS
        |-base-sync-stock               同步环球库存(已废弃)
        |-base-sync-stock-wms           同步WMS系统库存
        |-base-sync-transfer            同步调拨流水
        |-base-sync-warehouse           同步仓库信息
    |-data-mid                          中间数据处理
        |-mid-auto-turnover-prepare     扫描数据进自动周转列表
        |-mid-calculate-cost-first      计算头程费
        |-mid-calculate-sales           计算销量
        |-mid-calculate-transit         计算在途,缺货等数据
        |-mid-daily-stock               计算每日库存
        |-mid-fba-fee-avg               计算FBA平均费用
        |-mid-stored-procedure          帮.net同事跑一些定时任务
    |-data-show                         数据价值展现
        |-show-auto-turnover            自动周转逻辑   
```