package com.bailuntec.job;

import com.bailuntec.mapper.DcMidTransitMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;

import java.time.LocalDateTime;

@Slf4j
public class CalculateUnshippedJob implements SimpleJob {

    @Override
    public void execute(ShardingContext shardingContext) {
        SqlSession sqlSession = SessionUtil.getFactory().openSession(TransactionIsolationLevel.READ_UNCOMMITTED);
        try {
            DcMidTransitMapper mapper = sqlSession.getMapper(DcMidTransitMapper.class);
            mapper.calculateUnShipped();
            sqlSession.commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("计算未发货数失败",e);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
            }
        }
        SqlSession sqlSessionUpdate = SessionUtil.getFactory().openSession(TransactionIsolationLevel.READ_UNCOMMITTED);
        try {
            DcMidTransitMapper mapper = sqlSessionUpdate.getMapper(DcMidTransitMapper.class);
            LocalDateTime localDateTime = mapper.selectMaxUnshippedModified();
            mapper.updateOldUnshippedToZero(localDateTime);
            sqlSessionUpdate.commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("更新历史未发货数失败",e);
        } finally {
            if (sqlSessionUpdate != null) {
                sqlSessionUpdate.close();
            }
        }
    }
}
