package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.BorrowBalanceDTO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Repository
public interface DcShortTermBorrowMapper {
    @Insert("<script>" +
            "insert into dc_short_term_borrow(company_name,company_value,bank_card,bank_name,bank_card_user,creditor,balance_rmb,statistical_time) values " +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.companyName},#{item.companyValue},#{item.bankCard},#{item.bankName},#{item.bankCardUser},#{item.creditor},#{item.balanceRmb},#{lastDay})" +
            "</foreach>" +
            "</script>")
    void insertShortTermBorrow(@Param("list") List<BorrowBalanceDTO> borrowBalanceDTOList, @Param("lastDay") Date lastDay);

    /**
     * 短期借款总额
     * @param lastDay
     * @return
     */
    @Select("select sum(balance_rmb) from dc_short_term_borrow where statistical_time = #{lastDay}")
    BigDecimal getShortTermBorrowBalanceSum(@Param("lastDay") Date lastDay);
}
