package com.bailuntec.service.impl;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.constant.Constant;
import com.bailuntec.domain.entity.*;
import com.bailuntec.job.AutoTurnoverJob;
import com.bailuntec.job.ReplaceLogisticJob;

import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/2/22 2:06 下午
 */
public class TurnoverDaysHandler {

    public static final Integer SUPPLIER_DELIVERY_FLAG = 100;

    private final DcAveragePurchase dcAveragePurchase;
    private final DcBaseSku dcBaseSku;

    private final DcBaseWarehouse dcBaseWarehouse;
    private final DcAutoTurnover dcAutoTurnover;
    private final DcAverageWarehouse dcAverageWarehouse;
    private final DcAutoConfigDelivery dcAutoConfigDelivery;

    public TurnoverDaysHandler(DcAveragePurchase dcAveragePurchase, DcBaseSku dcBaseSku, DcBaseWarehouse dcBaseWarehouse, DcAutoTurnover dcAutoTurnover, DcAverageWarehouse dcAverageWarehouse, DcAutoConfigDelivery dcAutoConfigDelivery) {
        this.dcAveragePurchase = dcAveragePurchase;
        this.dcBaseSku = dcBaseSku;
        this.dcBaseWarehouse = dcBaseWarehouse;
        this.dcAutoTurnover = dcAutoTurnover;
        this.dcAverageWarehouse = dcAverageWarehouse;
        this.dcAutoConfigDelivery = dcAutoConfigDelivery;
    }

    /**
     * <p>
     * 通过公式计算周转天数
     * 1. 拿到供应商交期-turnoverSku和百伦分类Id-bailunFirstLevelCatagoryId
     * 2. 获取调拨头程 + 调拨打包 + 海外仓入库天数 的配置 dcAutoConfigDelivery
     * 3. 拿到仓库名称 和 仓库类型(可选) turnoverWarehouse
     *
     * <p>
     * 周转天数计算公式: 供应链长度 = 周转天数 = 供应商交期 + 入库时间(质检入库时间) + 调拨头程  + 调拨打包  + 海外仓入库 + 财务付款天数 + 采购平均下单天数 + 启航天数 + 调拨下单天数
     *
     * <p>
     * 模版方法
     */
    public void handleTurnoverDays() {

        //供应商交期
        this.handleSupplierDelivery();
        //入库时间(质检入库时间)
        this.handleInboundDelivery();
        //调拨头程
        this.handleTransferHeadDelivery();
        //调拨打包
        this.handleTransferBaleDelivery();
        //海外仓入库
        this.handleAbroadInboundDelivery();
        //财务付款天数
        this.handlePaymentBeforeDelivery();
        //采购平均下单天数
        this.handlePurchaseCreateOrderDays();
        //启航天数
        this.handleSailDays();
        //调拨下单天数
        this.handleTransferOrderDays();
        //汇总计算总周转天数
        this.sumTurnoverDays();
        //后置方法处理jit周转天数
        this.handleJit();
    }

    private void handleTransferOrderDays() {
        int transferOrderDays = 0;
        //海运的数据
        String shardingContext = AutoTurnoverJob.transferStrategy.get();
        if (dcAverageWarehouse != null && Constant.OCEAN_HEAD.equals(shardingContext)) {
            transferOrderDays = dcAverageWarehouse.getTransferOrderDaysOcean().intValue();
        }
        //空运的数据
        else if (dcAverageWarehouse != null && Constant.AIR_HEAD.equals(shardingContext)) {
            transferOrderDays = dcAverageWarehouse.getTransferOrderDaysEmpty().intValue();
        }
        //默认
        else if (dcAverageWarehouse != null) {
            transferOrderDays = dcAverageWarehouse.getTransferOrderDays().intValue();
        }
        dcAutoTurnover.setTransferOrderDays(transferOrderDays);
    }

    private void handleSailDays() {

        int sailDays = 0;

        //海运的数据
        String shardingContext = AutoTurnoverJob.transferStrategy.get();
        if (dcAverageWarehouse != null && Constant.OCEAN_HEAD.equals(shardingContext)) {
            sailDays = dcAverageWarehouse.getTransferSailDaysOcean().intValue();
        }

        //空运的数据
        else if (dcAverageWarehouse != null && Constant.AIR_HEAD.equals(shardingContext)) {
            sailDays = dcAverageWarehouse.getTransferSailDaysEmpty().intValue();
        }
        //默认
        else if (dcAverageWarehouse != null) {
            sailDays = dcAverageWarehouse.getTransferSailDays().intValue();
        }
        dcAutoTurnover.setTransferSailDays(sailDays);
    }

    private void sumTurnoverDays() {
        Integer turnoverDays = dcAutoTurnover.getSupplierDelivery()
                + dcAutoTurnover.getInspectionConfigDelivery()
                + dcAutoTurnover.getTransferDelivery()
                + dcAutoTurnover.getTransferBaleDelivery()
                + dcAutoTurnover.getTransferBaleDelivery()
                + dcAutoTurnover.getAbroadInboundDelivery()
                + dcAutoTurnover.getPaymentBeforeDelivery()
                + dcAutoTurnover.getPurchaseCreateOrderDays()
                + dcAutoTurnover.getTransferSailDays();

        dcAutoTurnover.setTurnoverDays(turnoverDays);
        DcAutoReplaceLogisticsTask dcAutoReplaceLogisticsTask = ReplaceLogisticJob.logisticsTaskThreadLocal.get();

        if (dcAutoReplaceLogisticsTask != null) {
            dcAutoTurnover.setAutoReplaceLogisticsTaskId(dcAutoReplaceLogisticsTask.getId());
        } else {
            dcAutoTurnover.setAutoReplaceLogisticsTaskId(0);
        }
    }

    /**
     * 供应商交期
     * 先取dc_average_purchase,如果平均交期没有
     * 再去SKUMS取, 取SKUMS数据的时候如果是国内仓，就还取dc_base_sku原来那个字段，否则就要取dc_base_sku原新字段（调拨交期)
     */
    private void handleSupplierDelivery() {

        Integer turnoverSupplierDelivery = dcAveragePurchase != null && dcAveragePurchase.getDeliveryDays() >= 0 ? dcAveragePurchase.getDeliveryDays() : -1;
        if (turnoverSupplierDelivery.equals(-1) || turnoverSupplierDelivery > SUPPLIER_DELIVERY_FLAG) {
            turnoverSupplierDelivery = dcBaseSku.getSupplierDelivery();

            //张莹霞 判断（呕...）
            boolean jitBuyerFlag = (Constant.BUYER_JIT_1.equals(dcBaseSku.getBuyerName()) || Constant.BUYER_JIT_2.equals(dcBaseSku.getBuyerName()));
            //如果非国内仓且是JIT，就取调拨交期
            if (!dcBaseWarehouse.getHqType().equals(CommonConstant.DOMESTIC_WAREHOUSE) && jitBuyerFlag) {
                turnoverSupplierDelivery = dcBaseSku.getTransferDelivery();
            }
        }
        dcAutoTurnover.setSupplierDelivery(turnoverSupplierDelivery);

    }

    /**
     * 处理质检入库天数
     */
    private void handleInboundDelivery() {
        //质检入库天数-配置值
        Integer inspectionConfigDelivery = Constant.INSPECTION_DELIVE;
        //质检入库天数-实际值
        Integer inspectionDelivery = Constant.INSPECTION_DELIVE;

        dcAutoTurnover.setInspectionConfigDelivery(inspectionConfigDelivery);

        //- case lms
        if (dcAverageWarehouse != null && dcAverageWarehouse.getInboundDays() > 0) {
            inspectionDelivery = dcAverageWarehouse.getInboundDays();
        }
        ////质检入库天数-实际值
        dcAutoTurnover.setInspectionDelivery(inspectionDelivery);
    }

    /**
     * 处理调拨头程计算
     */
    private void handleTransferHeadDelivery() {
        //调拨头程天数 - 配置值
        Integer transferConfigDelivery = dcAutoConfigDelivery.getTranferHead();
        dcAutoTurnover.setTransferConfigDelivery(transferConfigDelivery);
        //调拨头程天数 - 实际值
        Integer transferDelivery = dcAutoConfigDelivery.getTranferHead();
        // //调拨头程天数 - 来源
        String transferDeliverySource = Constant.SOURCE_AIMS;

        //来源切换lms
        if (dcAverageWarehouse != null && dcAverageWarehouse.getTransferDelivery().compareTo(BigDecimal.ZERO) > 0) {
            transferDeliverySource = Constant.SOURCE_LMS;
            transferDelivery = dcAverageWarehouse.getTransferDelivery().intValue();
        }
        //来源切换空运
        if (ReplaceLogisticJob.logisticsTaskThreadLocal.get() != null) {
            DcAutoReplaceLogisticsTask dcAutoReplaceLogisticsTask = ReplaceLogisticJob.logisticsTaskThreadLocal.get();
            transferDelivery = dcAutoReplaceLogisticsTask.getTransferDelivery().intValue();
            transferDeliverySource = Constant.SOURCE_AIR;

        }
        //海运的数据
        String shardingContext = AutoTurnoverJob.transferStrategy.get();
        if (dcAverageWarehouse != null && Constant.OCEAN_HEAD.equals(shardingContext)) {
            transferDeliverySource = Constant.SOURCE_LMS;
            transferDelivery = dcAverageWarehouse.getTransferDeliveryOcean().intValue();
        }

        //空运的数据
        if (dcAverageWarehouse != null && Constant.AIR_HEAD.equals(shardingContext)) {
            transferDeliverySource = Constant.SOURCE_LMS;
            transferDelivery = dcAverageWarehouse.getTransferDeliveryEmpty().intValue();
        }


        dcAutoTurnover.setTransferDeliverySource(transferDeliverySource);
        dcAutoTurnover.setTransferDelivery(transferDelivery);
    }


    /**
     * 处理调拨打包天数
     */
    private void handleTransferBaleDelivery() {
        //调拨打包天数 - 配置值
        Integer transferBaleConfigDelivery = dcAutoConfigDelivery.getTranferBale();
        dcAutoTurnover.setTransferBaleConfigDelivery(transferBaleConfigDelivery);
        //调拨打包天数 - 实际值
        Integer transferBaleDelivery = dcAutoConfigDelivery.getTranferBale();
        //调拨打包天数 - 来源
        String transferBaleDeliverySource = Constant.SOURCE_AIMS;

        //来源切换lms
        if (dcAverageWarehouse != null && dcAverageWarehouse.getTransferBaleDelivery().compareTo(BigDecimal.ZERO) > 0) {
            transferBaleDeliverySource = Constant.SOURCE_LMS;
            transferBaleDelivery = dcAverageWarehouse.getTransferBaleDelivery().intValue();
        }

        //来源切换空运
        if (ReplaceLogisticJob.logisticsTaskThreadLocal.get() != null) {
            DcAutoReplaceLogisticsTask dcAutoReplaceLogisticsTask = ReplaceLogisticJob.logisticsTaskThreadLocal.get();
            transferBaleDeliverySource = Constant.SOURCE_AIR;
            transferBaleDelivery = dcAutoReplaceLogisticsTask.getTransferBaleDelivery().intValue();
        }

        //海运的数据
        String shardingContext = AutoTurnoverJob.transferStrategy.get();
        if (dcAverageWarehouse != null && Constant.OCEAN_HEAD.equals(shardingContext)) {
            transferBaleDeliverySource = Constant.SOURCE_LMS;
            transferBaleDelivery = dcAverageWarehouse.getTransferBaleDeliveryOcean().intValue();
        }

        //空运的数据
        if (dcAverageWarehouse != null && Constant.AIR_HEAD.equals(shardingContext)) {
            transferBaleDeliverySource = Constant.SOURCE_LMS;
            transferBaleDelivery = dcAverageWarehouse.getTransferBaleDeliveryOcean().intValue();
        }

        dcAutoTurnover.setTransferBaleDeliverySource(transferBaleDeliverySource);
        dcAutoTurnover.setTransferBaleDelivery(transferBaleDelivery);
    }

    /**
     * 处理海外仓入库天数
     */
    private void handleAbroadInboundDelivery() {
        //海外仓入库天数 - 配置值
        Integer abroadInboundConfigDelivery = dcAutoConfigDelivery.getAbroadInbound();
        dcAutoTurnover.setAbroadInboundConfigDelivery(abroadInboundConfigDelivery);
        //海外仓入库天数 - 实际值
        Integer abroadInboundDelivery = dcAutoConfigDelivery.getAbroadInbound();
        //海外仓入库天数 - 来源
        String abroadInboundDeliverySource = Constant.SOURCE_AIMS;

        //来源切换lms
        if (dcAverageWarehouse != null && dcAverageWarehouse.getAbroadInboundDelivery().compareTo(BigDecimal.ZERO) > 0) {
            abroadInboundDelivery = dcAverageWarehouse.getAbroadInboundDelivery().intValue();
            abroadInboundDeliverySource = Constant.SOURCE_LMS;
        }

        //来源切换空运
        if (ReplaceLogisticJob.logisticsTaskThreadLocal.get() != null) {
            DcAutoReplaceLogisticsTask dcAutoReplaceLogisticsTask = ReplaceLogisticJob.logisticsTaskThreadLocal.get();
            abroadInboundDelivery = dcAutoReplaceLogisticsTask.getAbroadInboundDelivery().intValue();
            abroadInboundDeliverySource = Constant.SOURCE_AIR;
        }

        //海运的数据
        String shardingContext = AutoTurnoverJob.transferStrategy.get();
        if (dcAverageWarehouse != null && Constant.OCEAN_HEAD.equals(shardingContext)) {
            abroadInboundDeliverySource = Constant.SOURCE_LMS;
            abroadInboundDelivery = dcAverageWarehouse.getAbroadInboundDeliveryOcean().intValue();
        }

        //空运的数据
        if (dcAverageWarehouse != null && Constant.AIR_HEAD.equals(shardingContext)) {
            abroadInboundDeliverySource = Constant.SOURCE_LMS;
            abroadInboundDelivery = dcAverageWarehouse.getAbroadInboundDeliveryEmpty().intValue();
        }

        dcAutoTurnover.setAbroadInboundDelivery(abroadInboundDelivery);
        dcAutoTurnover.setAbroadInboundDeliverySource(abroadInboundDeliverySource);
    }

    /**
     * 处理下单天数
     */
    private void handlePaymentBeforeDelivery() {
        Integer paymentBeforeDelivery = 0;
        if (dcAveragePurchase != null) {
            paymentBeforeDelivery = dcAveragePurchase.getPaymentBeforeDelivery();
        }

        dcAutoTurnover.setPaymentBeforeDelivery(paymentBeforeDelivery);
    }

    /**
     * 处理平均采购天数
     */
    private void handlePurchaseCreateOrderDays() {
        Integer purchaseCreateOrderDays = 0;
        if (dcAveragePurchase != null) {
            purchaseCreateOrderDays = dcAveragePurchase.getCreateOrderDays();
        }
        dcAutoTurnover.setPurchaseCreateOrderDays(purchaseCreateOrderDays);
    }

    private void handleJit() {

        String warehouseCode = dcBaseWarehouse.getWarehouseCode();
        boolean jitBuyerFlag = (dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_1) || dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_2) || dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_3));
        if (warehouseCode.equals(Constant.WAREHOUSE_JIT) && jitBuyerFlag) {
            int turnoverDays;
            // JIT 周转天数默认为2、4天
            if (dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_2)) {
                turnoverDays = 2;
            } else {
                turnoverDays = 4;
            }
            dcAutoTurnover.setTurnoverDays(turnoverDays);
        }
    }
}
