package com.bailuntec.utils;

import com.bailuntec.annotation.TableExt;
import com.bailuntec.domain.entity.DcBaseOmsOrder;
import com.bailuntec.domain.entity.DcBaseOmsOrderExt;
import com.bailuntec.domain.pojo.TableExtBase;

import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
public class TableExtUtil<T extends TableExtBase,S>  {

    public List<T> setTargetTable (Class<T> targetClass, S source) throws IllegalAccessException, InstantiationException {
        List<T> targets = new ArrayList<T>();
        Field[] fields = source.getClass().getDeclaredFields();
        for (Field field : fields) {
            TableExt tableExt = field.getAnnotation(TableExt.class);
            if(tableExt != null){
                T ext = targetClass.newInstance();
                String key = tableExt.key();
                if(key == null || key.isEmpty()){
                    key = field.getName();
                }
                String value = "";
                try {
                    field.setAccessible(true);
                    value = field.get(source).toString();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ext.setKey(key);
                ext.setValue(value);
                targets.add(ext);
            }
        }
        return targets;
    }
}
