package com.bailuntec;

import com.bailuntec.domain.entity.JobAccountLog;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.enumerate.AccountPlatformType;
import com.bailuntec.domain.example.JobAccountLogExample;
import com.bailuntec.mapper.JobAccountLogMapper;
import com.bailuntec.utils.SessionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.junit.jupiter.api.Test;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
public class ApplicationTest {

    @Test
    public void test() {
        JobAccountLogMapper jobAccountLogMapper = SessionUtil.getSession().getMapper(JobAccountLogMapper.class);
        JobPointLog jobPointLog = new JobPointLog("base-sync-shopify", 1, 100, 1, 1, LocalDateTime.of(2019, 10, 01, 00, 00, 00), LocalDateTime.of(2019, 11, 28, 00, 00, 00));
        List<JobAccountLog> listByPage = jobAccountLogMapper.getListByPage(AccountPlatformType.Shopify.code(),0, 100);

        try{
            Class clazz = Class.forName("com.bailuntec.job.ShopifySyncJob");
            Method generateReportId = clazz.getDeclaredMethod("handleCampaign", JobAccountLog.class);
            generateReportId.setAccessible(true);
            if(listByPage != null && listByPage.size() > 0) {
                for (JobAccountLog jobAccountLog : listByPage) {
                    LocalDateTime localDateTime = jobAccountLog.getStartTime();
                    do{
                        if (jobAccountLog.getId() == null) {
                            BeanUtils.copyProperties(jobAccountLog, jobPointLog);
                            jobAccountLog.setId(null);
                        }
                        generateReportId.invoke(clazz.newInstance(), jobAccountLog);
                        localDateTime = localDateTime.plusDays(1L);
                    }while (!localDateTime.isAfter(jobAccountLog.getEndTime()));
                    jobAccountLog.setStartTime(jobAccountLog.getEndTime());
                    jobAccountLog.setEndTime(jobAccountLog.getStartTime().plusDays(jobAccountLog.getIntervalTime()).isAfter(LocalDateTime.now()) ? LocalDateTime.now() : jobAccountLog.getEndTime().plusDays(jobAccountLog.getIntervalTime()));
                    jobAccountLogMapper = SessionUtil.getSession().getMapper(JobAccountLogMapper.class);
                    if (jobAccountLog.getId() == null) {
                        jobAccountLogMapper.insertSelective(jobAccountLog);
                    } else {
                        jobAccountLog.setBjModified(LocalDateTime.now());
                        jobAccountLogMapper.updateByExampleSelective(jobAccountLog, JobAccountLogExample.newAndCreateCriteria().andAccountIdEqualTo(jobAccountLog.getAccountId()).andJobNameEqualTo(jobAccountLog.getJobName()).example());
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    @Test
    public void test1() {
        System.out.println(restart(1));
    }

    public long restart(int restartNum) {
        try{
            if(restartNum == 2) {
                return 10;
            }
            int i = 10/0;
            return 20;
        }catch (Exception e){
            if(restartNum == 5) {
                System.out.println("结束了。。。。");
                return restartNum;
            }else{
                restart(restartNum + 1);
                System.out.println("重跑第："+restartNum+"次");
                return restartNum;
            }

        }
    }
}
