package com.bailuntec;

import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.WishInfo;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.job.WishSyncJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;

@Slf4j
public class ApplicationTest {

    private OkHttpClient okHttpClient = OkHttpUtil.getInstance();
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");

    @Test
    public void testDate() {

        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("start_time", "2019-06-01");
        map.put("access_token", "8c4013273f7c4a9d9bfb519b365ed62e");
        map.put("limit", "50");
        Response response = null;
        String palResultStr = null;
        try {
            Request request = new Request.Builder()
                    .get()
                    .url(OkHttpUtil.attachHttpGetParams(propertiesUtil.getPropertyAsString("MULTI_CAMPAIGN_GET_URL"), map))
                    .addHeader("Content-Type", "application/json")
                    .build();
            response = okHttpClient.newCall(request).execute();
            palResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求流水接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        WishInfo wishAuthInfo = JSON.parseObject(palResultStr, WishInfo.class);
        if(wishAuthInfo.getCode() == 0) {
            wishAuthInfo.getData();
        }
    }

    @Test
    public void testWish() {
        ShardingContext shardingContext = new ShardingContext(new ShardingContexts("123", "amazonAddTask", 1, "", new HashMap()), 0);
        JobPointLog jobPointLog = new JobPointLog();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        jobPointLog.setStartTime(LocalDateTime.parse("2019-01-01 00:00:58", df));
        jobPointLog.setEndTime(LocalDateTime.parse("2019-07-04 00:00:58", df));
        jobPointLog.setJobName("base-sync-finance-wish");
        jobPointLog.setPageIndex(1);
        jobPointLog.setIntervalTime(1);
        new WishSyncJob().executeJob(shardingContext, jobPointLog);
    }

}
