//package com.bailuntec.service;
//
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.TypeReference;
//import com.bailuntec.domain.constant.CommonConstant;
//import com.bailuntec.domain.constant.Constant;
//import com.bailuntec.domain.dto.DateTurnover;
//import com.bailuntec.domain.dto.SalesVolumeAvgDTO;
//import com.bailuntec.domain.entity.*;
//import com.bailuntec.domain.enumerate.PlatformType;
//import com.bailuntec.domain.example.*;
//import com.bailuntec.job.ReplaceLogisticJob;
//import com.bailuntec.mapper.*;
//import com.bailuntec.utils.ListUtil;
//import com.bailuntec.utils.SessionUtil;
//import com.google.gson.Gson;
//import org.apache.commons.lang3.StringUtils;
//
//import java.math.BigDecimal;
//import java.math.RoundingMode;
//import java.time.LocalDate;
//import java.time.LocalDateTime;
//import java.time.Period;
//import java.time.format.DateTimeFormatter;
//import java.util.ArrayList;
//import java.util.Comparator;
//import java.util.List;
//import java.util.Map;
//import java.util.stream.Collectors;
//
//import static com.bailuntec.domain.constant.Constant.BUYER_JIT_123;
//import static com.bailuntec.domain.constant.Constant.WAREHOUSE_JIT;
//
///**
// * <p>
// *
// * </p>
// *
// * @author robbendev
// * @since 2021/1/14 2:17 下午
// */
//public class AutoTrunoverContext {
//
//    /*core*/
//    //核心
//    private DcAutoTurnoverWithBLOBs dcAutoTurnover;
//    private String bailunSku;
//    private String warehouseCode;
//
//    /*domain*/
//    //库存
//    private final DcBaseStock dcBaseStock;
//    //    //销量表
////    private final DcAutoSales dcAutoSales;
//    //仓库
//    private DcBaseWarehouse dcBaseWarehouse;
//    //销量突然增配置
//    private DcAutoUprushConfig dcAutoUprushConfig;
//
//    /*mapper*/
//    private final DcBaseWarehouseMapper dcBaseWarehouseMapper;
//    //销量表
//    private final DcAutoSalesMapper dcAutoSalesMapper;
//    //销量突增检测mapper
//    private final DcAutoUprushConfigMapper dcAutoUprushConfigMapper;
//
//    private LocalDateTime processTime;
//    private String processTimeStr;
//
//    public AutoTrunoverContext(DcBaseStock dcBaseStock,
//                               DcBaseWarehouseMapper dcBaseWarehouseMapper,
//                               DcAutoSalesMapper dcAutoSalesMapper,
//                               DcAutoUprushConfigMapper dcAutoUprushConfigMapper,
//                               DcAutoTurnoverMapper dcAutoTurnoverMapper,
//                               DcBaseSkuMapper dcBaseSkuMapper,
//                               DcAveragePurchaseMapper dcAveragePurchaseMapper,
//                               DcAverageWarehouseMapper dcAverageWarehouseMapper,
//                               AutoTurnoverService autoTurnoverService, DcBaseWeekCoefficientMapper dcBaseWeekCoefficientMapper, SalesDayConfigMapper salesDayConfigMapper, DateSalesService dateSalesService, DcAutoConfigSkuWarehouseMapper autoConfigSkuWarehouseMapper, List<DateTurnover> dateTurnoverList, DcBasePurchaseMapper dcBasePurchaseMapper, DcAutoConfigDeliveryMapper dcAutoConfigDeliveryMapper, DcAutoInboundMapper autoInboundMapper) {
//        //source
//        this.dcBaseStock = dcBaseStock;
//
//        //mapper
//        this.dcBaseWarehouseMapper = dcBaseWarehouseMapper;
//        this.dcAutoSalesMapper = dcAutoSalesMapper;
//        this.dcAutoUprushConfigMapper = dcAutoUprushConfigMapper;
//        this.dcAutoTurnoverMapper = dcAutoTurnoverMapper;
//        this.dcBaseSkuMapper = dcBaseSkuMapper;
//        this.dcAveragePurchaseMapper = dcAveragePurchaseMapper;
//        this.dcAverageWarehouseMapper = dcAverageWarehouseMapper;
//        this.autoTurnoverService = autoTurnoverService;
//        this.dcBaseWeekCoefficientMapper = dcBaseWeekCoefficientMapper;
//        this.salesDayConfigMapper = salesDayConfigMapper;
//        this.dateSalesService = dateSalesService;
//        this.autoConfigSkuWarehouseMapper = autoConfigSkuWarehouseMapper;
//        this.dateTurnoverList = dateTurnoverList;
//        this.dcBasePurchaseMapper = dcBasePurchaseMapper;
//        this.dcAutoConfigDeliveryMapper = dcAutoConfigDeliveryMapper;
//        this.autoInboundMapper = autoInboundMapper;
//        this.init();
//    }
//
//
//    public void init() {
//        this.initTime();
//        //初始化需要计算的周转领域对象
//        this.initTurnover();
//        //初始化任务上下文核心领域对象
//        this.initDomain();
//        //初始化任务上下文非核心领域对象
//        this.initNonCoreDomain();
//        //初始化 供应链长度 和 自动周转天数
//        this.initTurnoverDelivery();
//    }
//
//    //初始化供应链长度
//    private void initTurnoverDelivery() {
//
//
//        //1、供应商交期
//        Integer turnoverSupplierDelivery = 0;
//        //1.1 取采购平均指标 的平均交期
//        if (dcAveragePurchase != null) {
//            turnoverSupplierDelivery = dcAveragePurchase.getDeliveryDays();
//        }
//        //如果平均交期不存在或者平均交期>100
//        if (turnoverSupplierDelivery.equals(0) || turnoverSupplierDelivery > 100) {
//            //1.2 取基础sku的供应商交期
//            turnoverSupplierDelivery = dcBaseSku.getSupplierDelivery();
//            //1.2 非国内仓并且是JIT 取基础sku的调拨交期
//            if (!dcBaseWarehouse.getHqType().equals(CommonConstant.DOMESTIC_WAREHOUSE) &&
//                    (Constant.BUYER_JIT_1.equals(dcBaseSku.getBuyerName()) || Constant.BUYER_JIT_2.equals(dcBaseSku.getBuyerName()))) {
//                turnoverSupplierDelivery = dcBaseSku.getTransferDelivery();
//            }
//        }
//        dcAutoTurnover.setSupplierDelivery(turnoverSupplierDelivery);
//
//        //2.质检入库天数
//        Integer turnoverInboundDelivery = Constant.INSPECTION_DELIVE;
//        dcAutoTurnover.setInspectionConfigDelivery(turnoverInboundDelivery);
//
//        // lms、aims配置、读取产品库
//
//        // - case aims配置
//        // 3.调拨头程
//        Integer turnoverTransferHeadDelivery = dcAutoConfigDelivery.getTranferHead();
//        dcAutoTurnover.setTransferConfigDelivery(turnoverTransferHeadDelivery);
//        dcAutoTurnover.setTransferDeliverySource(DcAutoTurnover.SOURCE_AIMS);
//
//        //4.调拨打包
//        Integer turnoverTransferBaleDelivery = dcAutoConfigDelivery.getTranferBale();
//        dcAutoTurnover.setTransferBaleConfigDelivery(turnoverTransferBaleDelivery);
//        dcAutoTurnover.setTransferBaleDeliverySource(DcAutoTurnover.SOURCE_AIMS);
//
//        //5.海外仓入库
//        Integer turnoverAbroadInboundDelivery = dcAutoConfigDelivery.getAbroadInbound();
//        dcAutoTurnover.setAbroadInboundConfigDelivery(turnoverAbroadInboundDelivery);
//        dcAutoTurnover.setAbroadInboundDeliverySource(DcAutoTurnover.SOURCE_AIMS);
//
//
//        //- case lms 如果平均仓库指标不为空 切换lms配置
//        if (dcAverageWarehouse != null) {
//            //lms 配置的质检入库天数
//            if (dcAverageWarehouse.getInboundDays() > 0) {
//                turnoverInboundDelivery = dcAverageWarehouse.getInboundDays();
//                dcAutoTurnover.setInspectionDelivery(turnoverInboundDelivery);
//            }
//            //lms 调拨头程
//            if (dcAverageWarehouse.getTransferDelivery().compareTo(BigDecimal.ZERO) > 0) {
//                turnoverTransferHeadDelivery = dcAverageWarehouse.getTransferDelivery().intValue();
//                dcAutoTurnover.setTransferDeliverySource(DcAutoTurnover.SOURCE_LMS);
//                dcAutoTurnover.setTransferBaleDelivery(turnoverTransferHeadDelivery);
//            }
//            //lms 调拨打包
//            if (dcAverageWarehouse.getTransferBaleDelivery().compareTo(BigDecimal.ZERO) > 0) {
//                turnoverTransferBaleDelivery = dcAverageWarehouse.getTransferBaleDelivery().intValue();
//                dcAutoTurnover.setTransferBaleDeliverySource(DcAutoTurnover.SOURCE_LMS);
//                dcAutoTurnover.setTransferBaleConfigDelivery(turnoverTransferBaleDelivery);
//            }
//            //lms 海外仓入库
//            if (dcAverageWarehouse.getAbroadInboundDelivery().compareTo(BigDecimal.ZERO) > 0) {
//                turnoverAbroadInboundDelivery = dcAverageWarehouse.getAbroadInboundDelivery().intValue();
//                dcAutoTurnover.setAbroadInboundDeliverySource(DcAutoTurnover.SOURCE_LMS);
//                dcAutoTurnover.setAbroadInboundConfigDelivery(turnoverAbroadInboundDelivery);
//            }
//        }
//
//        //如果空运指标不为空 切换空运配置
//        // case 切换空运
//        DcAutoReplaceLogisticsTask dcAutoReplaceLogisticsTask = ReplaceLogisticJob.logisticsTaskThreadLocal.get();
//        if (dcAutoReplaceLogisticsTask != null) {
//
//            //空运 调拨头程
//            turnoverTransferHeadDelivery = dcAutoReplaceLogisticsTask.getTransferDelivery().intValue();
//            dcAutoTurnover.setTransferDeliverySource(DcAutoTurnover.SOURCE_AIR);
//            dcAutoTurnover.setTransferBaleDelivery(turnoverTransferHeadDelivery);
//
//            //空运 调拨打包
//            turnoverTransferBaleDelivery = dcAutoReplaceLogisticsTask.getTransferBaleDelivery().intValue();
//            dcAutoTurnover.setTransferBaleDeliverySource(DcAutoTurnover.SOURCE_AIR);
//            dcAutoTurnover.setTransferBaleConfigDelivery(turnoverTransferBaleDelivery);
//
//            //空运 海外仓入库
//            turnoverAbroadInboundDelivery = dcAutoReplaceLogisticsTask.getAbroadInboundDelivery().intValue();
//            dcAutoTurnover.setAbroadInboundDeliverySource(DcAutoTurnover.SOURCE_AIR);
//            dcAutoTurnover.setAbroadInboundConfigDelivery(turnoverAbroadInboundDelivery);
//
//            //记录空运配置id
//            dcAutoTurnover.setAutoReplaceLogisticsTaskId(dcAutoReplaceLogisticsTask.getId());
//        } else {
//            dcAutoTurnover.setAutoReplaceLogisticsTaskId(0);
//        }
//
//        //6、先款后货 或者 采购平均指标为空 供应链长度加一天
//        int paymentBeforeDelivery = 0;
//        if (dcAveragePurchase == null ||  &&dcAveragePurchase.getPaymentType().equals(1)){
//            paymentBeforeDelivery = 1;
//        }
//        dcAutoTurnover.setPaymentBeforeDelivery(paymentBeforeDelivery);
//
//        //周转期 =  供应商交期 + 质检天数 + 调拨头程 + 调拨打包 + 海外仓入库 + 先款后货
//        turnoverDays = turnoverSupplierDelivery + turnoverInboundDelivery + turnoverTransferHeadDelivery + turnoverTransferBaleDelivery + turnoverAbroadInboundDelivery + paymentBeforeDelivery;
//        dcAutoTurnover.setTurnoverDays(turnoverDays);
//
//        //jit的供应链长度特殊规则
//        if (warehouseCode.equals(WAREHOUSE_JIT) &&
//                (BUYER_JIT_123.contains(dcBaseSku.getBuyerName())) {
//            // JIT 周转天数默认为2、4天
//            if (dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_2)) {
//                turnoverDays = 2;
//            } else {
//                turnoverDays = 4;
//            }
//        }
//
//        // 周转预测天数等于2倍 周转期长度。2倍周转期长度 < 31 的, 默认算31天。但是生成的采购建议不拿2倍周转期以外的
//        autoForecastDay = turnoverDays * Constant.TURNOVER_MULTIPLE < Constant.MIN_AUTO_FORECAST_DAY ? Constant.MIN_AUTO_FORECAST_DAY : turnoverDays * 2;
//    }
//
//
//    //初始化执行时间
//    public void initTime() {
//        this.processTime = LocalDateTime.now();
//        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//        this.processTimeStr = fmt.format(processTime);
//    }
//
//    //初始化周转结果
//    public void initTurnover() {
//        bailunSku = dcBaseStock.getBailunSku();
//        warehouseCode = dcBaseStock.getWarehouseCode();
//        dcAutoTurnover = dcAutoTurnoverMapper.selectByUnionKey(bailunSku, warehouseCode);
//        if (dcAutoTurnover == null) {
//            dcAutoTurnover = new DcAutoTurnoverWithBLOBs();
//            dcAutoTurnover.setBailunSku(bailunSku);
//            dcAutoTurnover.setWarehouseCode(warehouseCode);
//            dcAutoTurnover.setGmtCreate(LocalDateTime.now());
//        }
//        dcAutoTurnover.setGmtModified(LocalDateTime.now());
//    }
//
//    //初始化相关领域
//    private void initDomain() {
//        //初始化 百伦基础sku
//        dcBaseSku = dcBaseSkuMapper.selectByUnionKey(bailunSku);
//        //初始化 仓库平均指标
//        dcAverageWarehouse = dcAverageWarehouseMapper.selectByUnionKey(bailunSku, warehouseCode);
//        //初始化 仓库
//        dcBaseWarehouse = dcBaseWarehouseMapper.selectByWarehouseCode(warehouseCode);
//    }
//
//
//    private void initNonCoreDomain() {
//        //初始化采购平均指标
//        dcAveragePurchase = dcAveragePurchaseMapper.selectByUnionKey(bailunSku, warehouseCode, dcBaseSku.getSuppliersId());
//        //初始化 销量突增配置
//        dcAutoUprushConfig = dcAutoUprushConfigMapper.selectByUnionKey(warehouseCode, dcBaseWarehouse.getHqType());
//        //初始化 调拨头程 + 调拨打包 + 海外仓入库天数 的配置
//        dcAutoConfigDelivery = this.getDcAutoConfigDelivery();
//    }
//
//
//    //获取调拨头程 + 调拨打包 + 海外仓入库天数 的配置
//    private DcAutoConfigDelivery getDcAutoConfigDelivery() {
//        DcAutoConfigDelivery dcAutoConfigDelivery = null;
//
//        //如果不是国内仓, 就读配置表
//        if (dcBaseWarehouse != null && !dcBaseWarehouse.getHqType().equals(CommonConstant.DOMESTIC_WAREHOUSE)) {
//            dcAutoConfigDelivery = dcAutoConfigDeliveryMapper.selectOneByExample(DcAutoConfigDeliveryExample.newAndCreateCriteria()
//                    .andVariableCodeEqualTo(warehouseCode)
//                    .andBailunSkuEqualTo(bailunSku)
//                    .andStatusEqualTo(1)
//                    .andTypeEqualTo(1).example());
//
//            if (dcAutoConfigDelivery == null) {
//                dcAutoConfigDelivery = dcAutoConfigDeliveryMapper.selectOneByExample(DcAutoConfigDeliveryExample.newAndCreateCriteria()
//                        .andVariableCodeEqualTo(dcBaseWarehouse.getHqType())
//                        .andBailunSkuEqualTo(bailunSku)
//                        .andStatusEqualTo(1)
//                        .andTypeEqualTo(2).example());
//            }
//            if (dcAutoConfigDelivery == null) {
//                dcAutoConfigDelivery = dcAutoConfigDeliveryMapper.selectOneByExample(DcAutoConfigDeliveryExample.newAndCreateCriteria()
//                        .andVariableCodeEqualTo(warehouseCode)
//                        .andStatusEqualTo(1)
//                        .andTypeEqualTo(3).example());
//            }
//            if (dcAutoConfigDelivery == null) {
//                dcAutoConfigDelivery = dcAutoConfigDeliveryMapper.selectOneByExample(DcAutoConfigDeliveryExample.newAndCreateCriteria()
//                        .andVariableCodeEqualTo(dcBaseWarehouse.getHqType())
//                        .andStatusEqualTo(1)
//                        .andTypeEqualTo(4).example());
//            }
//        }
//        if (dcAutoConfigDelivery == null) {
//            dcAutoConfigDelivery = new DcAutoConfigDelivery(0, 0, 0);
//        }
//        return dcAutoConfigDelivery;
//    }
//
//
//    public void process() {
//
//    }
//
//    private final DcAutoTurnoverMapper dcAutoTurnoverMapper;
//    private DcBaseSku dcBaseSku;
//    private final DcBaseSkuMapper dcBaseSkuMapper;
//    private final DcAveragePurchaseMapper dcAveragePurchaseMapper;
//    private final DcAverageWarehouseMapper dcAverageWarehouseMapper;
//
//    private final AutoTurnoverService autoTurnoverService;
//
//    //采购平均指标
//    private DcAveragePurchase dcAveragePurchase;
//    //仓库平均指标
//    private DcAverageWarehouse dcAverageWarehouse;
//
//
//    private void setWarehouseName() {
//        if (dcBaseWarehouse != null) {
//            dcAutoTurnover.setWarehouseName(dcBaseWarehouse.getWarehouseName());
//            if (dcBaseWarehouse.getSystemFlag().toUpperCase().equals(PlatformType.FBA.value())) {
//                dcAutoTurnover.setWarehouseName(dcBaseWarehouse.getBailunAccount());
//            }
//        }
//    }
//
//
//    private DcAutoConfigDelivery dcAutoConfigDelivery;
//    //周转天数
//    private Integer turnoverDays;
//    private Integer autoForecastDay;
//
//    private final DcBaseWeekCoefficientMapper dcBaseWeekCoefficientMapper;
//    private final SalesDayConfigMapper salesDayConfigMapper;
//
//    private final DateSalesService dateSalesService;
//
//    private void calculatePlatformAvgSales() {
//
//        DcAutoSalesMapper mapper = SessionUtil.getSession().getMapper(DcAutoSalesMapper.class);
//        SalesVolumeAvgDTO ebayAvgSales = mapper.getPlatformHistorySales(dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode(), PlatformType.Ebay.value());
//        dcAutoTurnover.setHistorySevendaySalesEbay(BigDecimal.ZERO);
//        dcAutoTurnover.setHistoryFourteendaySalesEbay(BigDecimal.ZERO);
//        dcAutoTurnover.setHistoryThirtydaySalesEbay(BigDecimal.ZERO);
//        if (ebayAvgSales != null) {
//            dcAutoTurnover.setHistorySevendaySalesEbay(BigDecimal.valueOf(ebayAvgSales.getSevendaySales()).divide(Constant.BIGDECIMAL_SEVEN, 3, RoundingMode.HALF_EVEN));
//            dcAutoTurnover.setHistoryFourteendaySalesEbay(BigDecimal.valueOf(ebayAvgSales.getFourteendaySales()).divide(Constant.BIGDECIMAL_FOURTEEN, 3, RoundingMode.HALF_EVEN));
//            dcAutoTurnover.setHistoryThirtydaySalesEbay(BigDecimal.valueOf(ebayAvgSales.getThirtydaySales()).divide(Constant.BIGDECIMAL_THIRTY, 3, RoundingMode.HALF_EVEN));
//        }
//
//        mapper = SessionUtil.getSession().getMapper(DcAutoSalesMapper.class);
//        SalesVolumeAvgDTO aliexpressAvgSales = mapper.getPlatformHistorySales(dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode(), PlatformType.Aliexpress.value());
//        dcAutoTurnover.setHistorySevendaySalesAliexpress(BigDecimal.ZERO);
//        dcAutoTurnover.setHistoryFourteendaySalesAliexpress(BigDecimal.ZERO);
//        dcAutoTurnover.setHistoryThirtydaySalesAliexpress(BigDecimal.ZERO);
//        if (aliexpressAvgSales != null) {
//            dcAutoTurnover.setHistorySevendaySalesAliexpress(BigDecimal.valueOf(aliexpressAvgSales.getSevendaySales()).divide(Constant.BIGDECIMAL_SEVEN, 3, RoundingMode.HALF_EVEN));
//            dcAutoTurnover.setHistoryFourteendaySalesAliexpress(BigDecimal.valueOf(aliexpressAvgSales.getFourteendaySales()).divide(Constant.BIGDECIMAL_FOURTEEN, 3, RoundingMode.HALF_EVEN));
//            dcAutoTurnover.setHistoryThirtydaySalesAliexpress(BigDecimal.valueOf(aliexpressAvgSales.getThirtydaySales()).divide(Constant.BIGDECIMAL_THIRTY, 3, RoundingMode.HALF_EVEN));
//        }
//
//        mapper = SessionUtil.getSession().getMapper(DcAutoSalesMapper.class);
//        SalesVolumeAvgDTO amazonAvgSales = mapper.getPlatformHistorySales(dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode(), PlatformType.Amazon.value());
//        dcAutoTurnover.setHistorySevendaySalesAmazon(BigDecimal.ZERO);
//        dcAutoTurnover.setHistoryFourteendaySalesAmazon(BigDecimal.ZERO);
//        dcAutoTurnover.setHistoryThirtydaySalesAmazon(BigDecimal.ZERO);
//        if (amazonAvgSales != null) {
//            dcAutoTurnover.setHistorySevendaySalesAmazon(BigDecimal.valueOf(amazonAvgSales.getSevendaySales()).divide(Constant.BIGDECIMAL_SEVEN, 3, RoundingMode.HALF_EVEN));
//            dcAutoTurnover.setHistoryFourteendaySalesAmazon(BigDecimal.valueOf(amazonAvgSales.getFourteendaySales()).divide(Constant.BIGDECIMAL_FOURTEEN, 3, RoundingMode.HALF_EVEN));
//            dcAutoTurnover.setHistoryThirtydaySalesAmazon(BigDecimal.valueOf(amazonAvgSales.getThirtydaySales()).divide(Constant.BIGDECIMAL_THIRTY, 3, RoundingMode.HALF_EVEN));
//        }
//
//    }
//
//    private Integer getStockUpDays(String warehouseCode) {
//        DcAutoConfigStockUpDaysMapper mapper = SessionUtil.getSession().getMapper(DcAutoConfigStockUpDaysMapper.class);
//        DcAutoConfigStockUpDays dcAutoConfigStockUpDays = mapper.selectOneByExample(DcAutoConfigStockUpDaysExample.newAndCreateCriteria().andWarehouseCodeEqualTo(warehouseCode).example());
//        if (dcAutoConfigStockUpDays != null && dcAutoConfigStockUpDays.getStatus() == 1) {
//            return dcAutoConfigStockUpDays.getStockUpDays();//备货天数减去1, 因为我们已经考虑到了一天的预计销量.
//        }
//        return 0;
//    }
//
//    private final DcAutoConfigSkuWarehouseMapper autoConfigSkuWarehouseMapper;
//
//    private DcAutoConfigSkuWarehouse getAutoConfigSkuWarehouse() {
//        return autoConfigSkuWarehouseMapper.selectOneByExample(DcAutoConfigSkuWarehouseExample.newAndCreateCriteria().andBailunSkuEqualTo(bailunSku).andWarehouseCodeEqualTo(warehouseCode).example());
//
//    }
//
//    private boolean actualForecastFluctuations() {
//
//        //默认是停止了监控波动功能的
//        boolean hasMonitorFluctuation = false;
//        /*
//         * 这个if判断单纯是为了判断实际冗余,然后存一个表给别人用
//         */
//        if (realInventory > forecastSalesList.get(0).add(totalSafeInventory).doubleValue()) {
//            DcAutoDailyRedundance dcAutoDailyRedundance = new DcAutoDailyRedundance();
//            float v = realInventory - forecastSalesList.get(0).add(totalSafeInventory).floatValue();
//            dcAutoDailyRedundance.setQuantity(Math.round(v));
//            dcAutoDailyRedundance.setBailunSku(dcAutoTurnover.getBailunSku());
//            dcAutoDailyRedundance.setWarehouseCode(dcAutoTurnover.getWarehouseCode());
//            dcAutoDailyRedundance.setWarehouseName(dcAutoTurnover.getWarehouseName());
//            dcAutoDailyRedundance.setRecordTime(LocalDate.now().minusDays(1));
//
//            DcAutoDailyRedundanceMapper mapper = SessionUtil.getSession().getMapper(DcAutoDailyRedundanceMapper.class);
//            int i = mapper.updateByExampleSelective(dcAutoDailyRedundance, DcAutoDailyRedundanceExample.newAndCreateCriteria().andBailunSkuEqualTo(dcAutoDailyRedundance.getBailunSku()).andWarehouseCodeEqualTo(dcAutoDailyRedundance.getWarehouseCode()).andRecordTimeEqualTo(dcAutoDailyRedundance.getRecordTime()).example());
//            if (i == 0) {
//                mapper.insertSelective(dcAutoDailyRedundance);
//            }
//
//        }
//
//        if ((dcAutoConfigSkuWarehouse == null && (realInventory > 0 || avgHistoryFourteenSales.compareTo(BigDecimal.ZERO) > 0)) || (dcAutoConfigSkuWarehouse != null && dcAutoConfigSkuWarehouse.getStatus() == 0 && (realInventory > 0 || avgHistoryFourteenSales.compareTo(BigDecimal.ZERO) > 0))) {
//            hasMonitorFluctuation = true;
//        }
//        return hasMonitorFluctuation;
//    }
//
//    private void unusualFluctuation() {
//
//        //连续冗余或缺货天数
//        int days = 0;
//        //冗余或缺货天数索引
//        int index = -1;
//
////        if (forecastShortSupplyList.get(turnoverDays).compareTo(BigDecimal.ZERO) > 0) {
//        for (int i = 0; i <= turnoverDays; i++) {
//            if (forecastShortSupplyList.get(i).compareTo(BigDecimal.ZERO) > 0) {
//                days++;
//                if (index < 0) {
//                    index = i;
//                }
//                if (i == turnoverDays) {  //如果是最后一天
//                    handleForecastFluctuation(2, forecastFluctuationList, recordTime, days, index);
//                    days = 0;
//                    index = -1;
//                }
//            } else if (index >= 0) {
//                handleForecastFluctuation(2, forecastFluctuationList, recordTime, days, index);
//                break;
//            }
//        }
////        }
//
//        //status`  '监控状态, 默认0监控, 停止监控1',
//        DcAutoForecastFluctuationMapper mapper = SessionUtil.getSession().getMapper(DcAutoForecastFluctuationMapper.class);
//        //JIT的 可以不做 冗余 和 缺货预测 实际冗余和实际缺货也不用提醒
//        //如果仓库是广州01 且 是这三个销售员, 就不提醒
//        if (!warehouseCode.equals(WAREHOUSE_JIT)
//                || !turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_1)
//                && !turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_2)
//                && !turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_3)) {
//            if (dcAutoConfigSkuWarehouse == null || dcAutoConfigSkuWarehouse.getStatus().equals(0)) {
//                if (forecastFluctuationList != null && forecastFluctuationList.size() > 0) {
//
//                    //拿最早的时间  +  最晚的时间, SKU-仓库维度只放一条
//                    DcAutoForecastFluctuation dcAutoForecastFluctuation = forecastFluctuationList.get(0);
//                    dcAutoForecastFluctuation.setStartTime(forecastFluctuationList.get(0).getStartTime());
//                    dcAutoForecastFluctuation.setEndTime(forecastFluctuationList.get(0).getEndTime());
//                    dcAutoForecastFluctuation.setBailunSku(turnoverSku.getBailunSku());
//                    dcAutoForecastFluctuation.setWarehouseCode(warehouseCode);
//                    dcAutoForecastFluctuation.setWarehouseName(dcAutoTurnover.getWarehouseName());
//                    dcAutoForecastFluctuation.setAvgSalesThree(avgHistoryThreedaySales);
//
//
//                    if (forecastFluctuationList.get(0).getType() != 1 && dcBaseStock.getUsableStock() == 0) {
//                        //获取前一天库存
//                        Integer yesterdayStock = mapper.yesterdayStock(dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode());
//                        if (yesterdayStock != null && yesterdayStock > 0) {
//                            dcAutoForecastFluctuation.setType(5); //实际断货
//                            dcAutoForecastFluctuation.setStartTime(LocalDate.now());  //保存当天日期
//                            dcAutoForecastFluctuation.setEndTime(LocalDate.now());    //保存当天日期
//                        }
//                    }
//
//                    //End Add
//
//                    int i = mapper.updateByExampleSelective(dcAutoForecastFluctuation, DcAutoForecastFluctuationExample.newAndCreateCriteria().andBailunSkuEqualTo(dcAutoForecastFluctuation.getBailunSku()).andWarehouseCodeEqualTo(dcAutoForecastFluctuation.getWarehouseCode()).example());
//                    if (i == 0) {
//                        mapper.insertSelective(dcAutoForecastFluctuation);
//                    }
//                } else {
//                    mapper.deleteByExample(DcAutoForecastFluctuationExample.newAndCreateCriteria()
//                            .andBailunSkuEqualTo(turnoverSku.getBailunSku())
//                            .andWarehouseCodeEqualTo(warehouseCode).example());
//                }
//            } else if (dcAutoConfigSkuWarehouse.getStatus().equals(1)) {
//                mapper.deleteByExample(DcAutoForecastFluctuationExample.newAndCreateCriteria()
//                        .andBailunSkuEqualTo(turnoverSku.getBailunSku())
//                        .andWarehouseCodeEqualTo(warehouseCode).example());
//            }
//        }
//
//    }
//
//    private BigDecimal calculateWeightingAvgSales() {
//        List<BigDecimal> historySevenSalesList = new ArrayList<>(7);
//        List<BigDecimal> historyFourteenSalesList = new ArrayList<>(14);
//        for (int i = 16; i < salesList.size(); i++) {
//            historyFourteenSalesList.add(salesList.get(i));
//            if (i >= 23) {
//                historySevenSalesList.add(salesList.get(i));
//            }
//        }
//        //自定义Comparator对象，自定义排序
//        Comparator<BigDecimal> c = (o1, o2) -> Integer.compare(0, o1.compareTo(o2));
//        salesList.sort(c);
//        historyFourteenSalesList.sort(c);
//        historySevenSalesList.sort(c);
//        BigDecimal thirtyHistorySales = BigDecimal.ZERO;
//        BigDecimal fourteenHistorySales = BigDecimal.ZERO;
//        BigDecimal sevenHistorySales = BigDecimal.ZERO;
//        for (int i = 1; i < salesList.size() - 1; i++) {
//            thirtyHistorySales = thirtyHistorySales.add(salesList.get(i));
//        }
//        for (int i = 1; i < historyFourteenSalesList.size() - 1; i++) {
//            fourteenHistorySales = fourteenHistorySales.add(historyFourteenSalesList.get(i));
//        }
//        for (int i = 1; i < historySevenSalesList.size() - 1; i++) {
//            sevenHistorySales = sevenHistorySales.add(historySevenSalesList.get(i));
//        }
//        BigDecimal weightingSevenAvgSales = thirtyHistorySales.divide(BigDecimal.valueOf(salesList.size() - 2), 3, RoundingMode.HALF_EVEN);
//        BigDecimal weightingFourteenAvgSales = fourteenHistorySales.divide(BigDecimal.valueOf(historyFourteenSalesList.size() - 2), 3, RoundingMode.HALF_EVEN);
//        BigDecimal weightingThirtyAvgSales = sevenHistorySales.divide(BigDecimal.valueOf(historySevenSalesList.size() - 2), 3, RoundingMode.HALF_EVEN);
//        return weightingSevenAvgSales.multiply(weightingCoefficientSeven).add(weightingFourteenAvgSales.multiply(weightingCoefficientFourteen)).add(weightingThirtyAvgSales.multiply(weightingCoefficientThirty)).setScale(3, RoundingMode.HALF_EVEN);
//    }
//
//    private List<DateTurnover> dateTurnoverList;
//
//    private final DcBasePurchaseMapper dcBasePurchaseMapper;
//    private final DcBaseTransferVerifyMapper dcBaseTransferVerifyMapper;
//    private final DcBaseTransExpectarrivaltimeMapper dcBaseTransExpectarrivaltimeMapper;
//    private final DcBaseWarehouseMapper dcBaseWarehouseMapper;
//
//    private void expectedStorage() {
//
//        if (dcMidTransit.getQuantityPurchase() > 0) {
//            // 找采购在途的采购单
//            List<DcBasePurchase> dcBasePurchaseList = dcBasePurchaseMapper.listPurchaseTransitOrder(dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode());
//
//            if (ListUtil.isNotEmpty(dcBasePurchaseList)) {
//                for (DcBasePurchase dcBasePurchase : dcBasePurchaseList) {
//                    if (dcBasePurchase.getCount() > 0) {
//                        LocalDateTime finalEstimatedArrivalTime;
//                        //调拨采购单
//                        if (dcBasePurchase.getHasTransfer() == 1) {
//                            finalEstimatedArrivalTime = dcBasePurchase.getEstimatedArrivalTime().plusDays(dcAutoTurnover.getInspectionDelivery()).plusDays(dcAutoTurnover.getTransferBaleDelivery()).plusDays(dcAutoTurnover.getTransferDelivery()).plusDays(dcAutoTurnover.getAbroadInboundDelivery());
//                        }
//                        //普通采购单
//                        else {
//                            finalEstimatedArrivalTime = dcBasePurchase.getEstimatedArrivalTime().plusDays(dcAutoTurnover.getInspectionDelivery());
//                        }
//                        DateTurnover dateTurnover = this.getDateTurnoverByDate(finalEstimatedArrivalTime.toLocalDate());
//                        //预测入库解释
//                        dateTurnover.setForecastInboundRelation(dateTurnover.getForecastInboundRelation() + "*" + Constant.PURCHASE_SIGN + dcBasePurchase.getPurchaseId() + "_" + dcBasePurchase.getCount());
//                        //预测采购入库
//                        dateTurnover.setForecastPurchaseInbound(dateTurnover.getForecastPurchaseAdvised().add(new BigDecimal(dcBasePurchase.getCount())));
//                        //预测入库
//                        dateTurnover.setForecastInbound(dateTurnover.getForecastPurchaseInbound().add(dateTurnover.getForecastTransferInbound()));
//                    }
//                }
//            }
//        }
//        //拿调拨单流水
//        if (dcMidTransit.getQuantityTransfer() > 0) {
//
//            // 找调拨在途的采购单
//            List<DcBaseTransferVerify> dcBaseTransferVerifyList = dcBaseTransferVerifyMapper.listTransferTransitOrder(dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode());
//            if (ListUtil.isNotEmpty(dcBaseTransferVerifyList)) {
//
//                for (DcBaseTransferVerify dcBaseTransferVerify : dcBaseTransferVerifyList) {
//                    if (dcBaseTransferVerify.getCount() > 0) {
//                        LocalDateTime finalEstimatedArrivalTime;
//                        if (dcBaseTransferVerify.getEstimatedArrivalTime() != null && dcBaseTransferVerify.getEstimatedArrivalTime().isAfter(Constant.INIT_DATE_TIME)) {
//                            finalEstimatedArrivalTime = dcBaseTransferVerify.getEstimatedArrivalTime().plusDays(dcAutoTurnover.getInspectionConfigDelivery());
//                        } else {
//                            finalEstimatedArrivalTime = dcBaseTransferVerify.getCreateTime().plusDays(dcAutoConfigDelivery.getAbroadInbound()).plusDays(dcAutoConfigDelivery.getTranferBale()).plusDays(dcAutoConfigDelivery.getTranferHead());
//                        }
//                        DateTurnover dateTurnover = this.getDateTurnoverByDate(finalEstimatedArrivalTime.toLocalDate());
//
//                        dateTurnover.setForecastInboundRelation(dateTurnover.getForecastInboundRelation() + "*" + Constant.TRANSFER_SIGN + dcBaseTransferVerify.getTransferOrderId() + "_" + dcBaseTransferVerify.getCount());
//                        //todo fba的调拨在途，切换读我做的一个新表（表结构构建中）
//                        DcBaseWarehouse dcBaseWarehouse = dcBaseWarehouseMapper.selectByWarehouseCode(dcAutoTurnover.getWarehouseCode())
//
//                        if (!dcBaseWarehouse.getSystemFlag().toUpperCase().equals(PlatformType.FBA.value())) {
//                            //预测调拨入库
//                            dateTurnover.setForecastTransferInbound(dateTurnover.getForecastTransferInbound().add(new BigDecimal(dcBaseTransferVerify.getCount())));
//                            //预测入库
//                            dateTurnover.setForecastInbound(dateTurnover.getForecastPurchaseInbound().add(dateTurnover.getForecastTransferInbound()));
//                        }
//                    }
//                }
//            }
//        }
//
//
//        DcBaseWarehouse dcBaseWarehouse = dcBaseWarehouseMapper.selectOneByExample(DcBaseWarehouseExample
//                .newAndCreateCriteria()
//                .andWarehouseCodeEqualTo(dcAutoTurnover.getWarehouseCode())
//                .example());
//
//        if (dcBaseWarehouse.getSystemFlag().toUpperCase().equals(PlatformType.FBA.value())) {
//
//            // 找调拨在途的采购单
//            List<DcBaseTransExpectarrivaltime> dcBaseTransExpectarrivaltimeList = dcBaseTransExpectarrivaltimeMapper.selectByExample(DcBaseTransExpectarrivaltimeExample
//                    .newAndCreateCriteria()
//                    .andBailunSkuEqualTo(dcAutoTurnover.getBailunSku())
//                    .andWarehouseCodeEqualTo(dcAutoTurnover.getWarehouseCode())
//                    .example());
//
//            Map<LocalDate, List<DcBaseTransExpectarrivaltime>> map = dcBaseTransExpectarrivaltimeList.stream().collect(Collectors.groupingBy(item -> item.getExpectarrivaltime().toLocalDate()));
//            map.forEach((localDate, dcBaseTransExpectarrivaltimes) -> {
//                int interval = Period.between(recordTime, localDate).getDays();
//                int index = Math.max(interval, 0);
//
//                forecastInboundRelationList.set(index, forecastInboundRelationList.get(index) + dcBaseTransExpectarrivaltimes.stream().map(dcBaseTransExpectarrivaltime -> Constant.TRANSFER_SIGN + dcBaseTransExpectarrivaltime.getTransferOrderId() + "_" + dcBaseTransExpectarrivaltime.getCount()).collect(Collectors.joining("*")));
//                forecastTransferInboundList.set(index, forecastTransferInboundList.get(index) + dcBaseTransExpectarrivaltimes.stream().mapToInt(DcBaseTransExpectarrivaltime::getCount).sum());
//                forecastInboundList.set(index, forecastPurchaseInboundList.get(index) + forecastTransferInboundList.get(index));
//
//            });
//        }
//
//    }
//
//    private BigDecimal calculateSafeInventory() {
//
//        DcAutoStockUpRangeMapper dcAutoStockUpRangeMapper = SessionUtil.getSession().getMapper(DcAutoStockUpRangeMapper.class);
//        DcAutoStockUpRange dcAutoStockUpRange = dcAutoStockUpRangeMapper.selectOneByExample(DcAutoStockUpRangeExample.newAndCreateCriteria().andBailunSkuEqualTo(bailunSku).andWarehouseCodeEqualTo(warehouseCode).example());
//        if ((warehouseCode.equals(WAREHOUSE_JIT) && (dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_1) || turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_2) || turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_3))) || dcAutoStockUpRange != null || (warehouseCode.equals(Constant.WAREHOUSE_JIT1) && (turnoverSku.getBuyerName().equals(Constant.BUTER_JIT_5)))) {
//
//            List<BigDecimal> historyThirtySalesList = JSON.parseObject(dcAutoSales.getHistorySalesDetails(), new TypeReference<List<BigDecimal>>() {
//            });
//            BigDecimal weightingAvgSales = calculateWeightingAvgSales(BigDecimal.valueOf(0.3), BigDecimal.valueOf(0.3), BigDecimal.valueOf(0.4), historyThirtySalesList);
//            if (dcAutoStockUpRange == null && (warehouseCode.equals(Constant.WAREHOUSE_JIT1) && (turnoverSku.getBuyerName().equals(Constant.BUTER_JIT_5)))) {
//                dcAutoStockUpRange = new DcAutoStockUpRange();
//                dcAutoStockUpRange.setBailunSku(bailunSku);
//                dcAutoStockUpRange.setGroupId(2);
//                dcAutoStockUpRange.setWarehouseCode(warehouseCode);
//                dcAutoStockUpRange.setWarehouseName("百伦【广州-03仓】");
//                dcAutoStockUpRangeMapper.insertSelective(dcAutoStockUpRange);
//            }
//            BigDecimal saveDays = getSaveDays(dcAutoSales, dcAutoTurnover, bailunSku, turnoverSku.getBuyerName(), "weightingAvgSales", dcAutoStockUpRange);
//            saveDaysMap.put("saveDays", saveDays);
//            dcAutoTurnover.setDailyWeightedSales(weightingAvgSales);
//            weightingAvgSales = weightingAvgSales.multiply(saveDays);
//            return weightingAvgSales;
//        } else {
//
//            DcAutoConfigSafeInventoryMapper autoConfigSafeInventoryMapper;
//            DcAutoConfigSafeInventory dcAutoConfigSafeInventory;
//
//            autoConfigSafeInventoryMapper = SessionUtil.getSession().getMapper(DcAutoConfigSafeInventoryMapper.class);
//            dcAutoConfigSafeInventory = autoConfigSafeInventoryMapper.selectOneByExample(DcAutoConfigSafeInventoryExample.newAndCreateCriteria().andVariableCodeEqualTo(bailunSku).andWarehouseCodeEqualTo(warehouseCode).andStatusEqualTo(1).andTypeEqualTo(1).example());
//
//            if (dcAutoConfigSafeInventory == null) {
//                if (bailunFirstLevelCategoryId != null) {//部分SKU没有百伦分类Id
//                    dcAutoConfigSafeInventory = autoConfigSafeInventoryMapper.selectOneByExample(DcAutoConfigSafeInventoryExample.newAndCreateCriteria().andVariableCodeEqualTo(bailunFirstLevelCategoryId.toString()).andWarehouseCodeEqualTo(warehouseCode).andStatusEqualTo(1).andTypeEqualTo(2).example());
//                }
//            }
//            if (dcAutoConfigSafeInventory == null) {
//                BigDecimal weightingAvgSales;
//                //预测
//                dcAutoConfigSafeInventory = autoConfigSafeInventoryMapper.selectOneByExample(DcAutoConfigSafeInventoryExample.newAndCreateCriteria().andVariableCodeEqualTo(bailunSku).andWarehouseCodeEqualTo(warehouseCode).andStatusEqualTo(1).andTypeEqualTo(12).example());
//                if (dcAutoConfigSafeInventory != null) {
//                    List<BigDecimal> forecastSalesList = JSON.parseObject(forecastSalesListJson, new TypeReference<List<BigDecimal>>() {
//                    });
//                    forecastSalesList.remove(forecastSalesList.size() - 1);
//                    weightingAvgSales = calculateWeightingAvgSales(dcAutoConfigSafeInventory.getWeightingCoefficientSeven(), dcAutoConfigSafeInventory.getWeightingCoefficientFourteen(), dcAutoConfigSafeInventory.getWeightingCoefficientThirty(), forecastSalesList);
//                } else {
//                    //历史
//                    dcAutoConfigSafeInventory = autoConfigSafeInventoryMapper.selectOneByExample(DcAutoConfigSafeInventoryExample.newAndCreateCriteria().andVariableCodeEqualTo(bailunSku).andWarehouseCodeEqualTo(warehouseCode).andStatusEqualTo(1).andTypeEqualTo(11).example());
//                    List<BigDecimal> historyThirtySalesList = JSON.parseObject(dcAutoSales.getHistorySalesDetails(), new TypeReference<List<BigDecimal>>() {
//                    });
//                    if (dcAutoConfigSafeInventory != null) {
//                        weightingAvgSales = calculateWeightingAvgSales(dcAutoConfigSafeInventory.getWeightingCoefficientSeven(), dcAutoConfigSafeInventory.getWeightingCoefficientFourteen(), dcAutoConfigSafeInventory.getWeightingCoefficientThirty(), historyThirtySalesList);
//                    } else {
//                        //仓库。根据历史销量加权计算。最后可以乘以一个倍数
//                        dcAutoConfigSafeInventory = autoConfigSafeInventoryMapper.selectOneByExample(DcAutoConfigSafeInventoryExample.newAndCreateCriteria().andVariableCodeEqualTo("").andWarehouseCodeEqualTo(warehouseCode).andStatusEqualTo(1).andTypeEqualTo(3).example());
//                        if (dcAutoConfigSafeInventory != null) {
//                            weightingAvgSales = calculateWeightingAvgSales(dcAutoConfigSafeInventory.getWeightingCoefficientSeven(), dcAutoConfigSafeInventory.getWeightingCoefficientFourteen(), dcAutoConfigSafeInventory.getWeightingCoefficientThirty(), historyThirtySalesList);
//                            dcAutoTurnover.setDailyWeightedSales(weightingAvgSales);
//                            //乘倍数后的加权日均销量,小于0.8就置0   0.8-1 之间就置1
//                            weightingAvgSales = weightingAvgSales.multiply(dcAutoConfigSafeInventory.getParam()).setScale(3, RoundingMode.HALF_EVEN);
//                            if (weightingAvgSales.compareTo(BigDecimal.valueOf(0.8)) < 0) {
//                                weightingAvgSales = BigDecimal.ZERO;
//                            } else if (weightingAvgSales.compareTo(BigDecimal.ONE) <= 0) {
//                                weightingAvgSales = BigDecimal.ONE;
//                            }
//                        } else {
//                            //啥配置都没有就给个默认取值
//                            weightingAvgSales = calculateWeightingAvgSales(BigDecimal.valueOf(0.3), BigDecimal.valueOf(0.3), BigDecimal.valueOf(0.4), historyThirtySalesList);
//                            dcAutoTurnover.setDailyWeightedSales(weightingAvgSales);
//                        }
//                    }
//                }
//                return weightingAvgSales;
//            } else {
//                return dcAutoConfigSafeInventory.getParam();
//            }
//
//        }
//    }
//
//    //通过SKU和仓库拿到实际库存
//    private final Integer realInventory;
//
//    private DateTurnover getDateTurnoverByDate(LocalDate localDate) {
//        return dateTurnoverList.stream()
//                .filter(dateTurnover -> dateTurnover.getDate().equals(localDate))
//                .findAny()
//                .orElse(null)
//    }
//
//    private void fxx() {
//        dateTurnoverList.forEach(dateTurnover -> {
//            //昨天的周转预测
//            DateTurnover lastDateTurnover = this.getDateTurnoverByDate(dateTurnover.getDate().minusDays(1));
//            //昨天预测缺货
//            if (lastDateTurnover.getForecastShortSupply().compareTo(BigDecimal.ZERO) > 0) {
//                dateTurnover.setForecastSales(BigDecimal.ZERO);
//                dateTurnover.setForecastSalesExplain("昨天预测缺货");
//                //处理自动周转预测断货和冗余波动
//                this.handleAutoFastestStorage(dateTurnover);
//            }
//        });
//    }
//
//    //return 库存可用天数
//    //在两倍周转期内, 如果预测销量 <= 库存, 那么又是可用的一天
//    private Integer fbaAdvise() {
//
//        dateTurnoverList.forEach(dateTurnover -> {
//            //result
//            //预计库存
//            BigDecimal forecastInventory;
//            //缺货数量
//            BigDecimal shortSupply;
//            //// 补断货的数量
//            BigDecimal addShortSupply;
//            //当天
//            if (dateTurnover.getDate().equals(LocalDate.now())) {
//                //缺货>0
//                if (dcMidTransit.getQuantityOutStock() > 0) {
//
//                    //预测销量0
//                    dateTurnover.setForecastSales(BigDecimal.ZERO);
//                    dateTurnover.setForecastSalesExplain("0, 昨天真实缺货");
//
//                    //预计库存: 第一天预计库存 =  预计入库 - 缺货数
//                    forecastInventory = dateTurnover.getForecastInbound().subtract(new BigDecimal(dcMidTransit.getQuantityOutStock()));
//                    ////库存补入后的 缺货数
//                    shortSupply = forecastInventory.compareTo(BigDecimal.ZERO) < 0 ? forecastInventory.abs() : BigDecimal.ZERO;
//                    //今天的缺货数
//                    BigDecimal subtract = dateTurnover.getForecastSales().subtract(forecastInventory.compareTo(BigDecimal.ZERO) > 0 ? forecastInventory : BigDecimal.ZERO);
//                    shortSupply = subtract.add(shortSupply).compareTo(BigDecimal.ZERO) > 0 ? subtract.add(shortSupply) : BigDecimal.ZERO;
//                }
//                //没有缺货
//                else {
//                    //第一天预计库存 =  真实库存 + 预计入库
//                    forecastInventory = dateTurnover.getForecastInbound().add(new BigDecimal(realInventory));
//                    BigDecimal subtract = dateTurnover.getForecastSales().subtract(forecastInventory);
//                    shortSupply = subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO;
//                }
//                //预测缺货数量
//                dateTurnover.setForecastShortSupply(shortSupply);
//            }
//            //计算当天之后的天数
//            else {
//                DateTurnover lastDateTurnover = this.getDateTurnoverByDate(dateTurnover.getDate().minusDays(1));
//                //预测库存 = 昨天预计入库 + 这天预计入库 - 昨天预计销量
//                forecastInventory = dateTurnover.getForecastInbound().add(lastDateTurnover.getForecastInbound()).subtract(lastDateTurnover.getForecastSales());
//                //为负的情况下, 应该为0
//                if (forecastInventory.compareTo(BigDecimal.ZERO) < 0) {
//                    forecastInventory = BigDecimal.ZERO;
//                }
//                //库存补断货数量 = 这天的预测库存 - 昨天预计缺货
//                addShortSupply = forecastInventory.subtract(lastDateTurnover.getForecastShortSupply());
//                if (addShortSupply.compareTo(BigDecimal.ZERO) < 0) {
//                    forecastInventory = BigDecimal.ZERO;
//                    dateTurnover.setForecastShortSupply(addShortSupply.abs());
//                } else {
//                    dateTurnover.setForecastShortSupply(BigDecimal.ZERO);
//                    forecastInventory = addShortSupply;
//                }
//                //今日断货
//                BigDecimal subtract = dateTurnover.getForecastSales().subtract(forecastInventory);
//                shortSupply = subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO;
//                dateTurnover.setForecastShortSupply(dateTurnover.getForecastShortSupply().add(shortSupply));
//            }
//            // set 预计库存
//            dateTurnover.setForecastInventory(forecastInventory);
//
//        });
//
//
//    }
//
//    private void handleAutoFastestStorage(DateTurnover dateTurnover) {
//    }
//
//    private void handleForecastFluctuation() {
//
//        DcAutoForecastFluctuation forecastFluctuation = new DcAutoForecastFluctuation();
//        forecastFluctuation.setStartTime(recordTime.plusDays(forecastFluctuationIndex));
//        forecastFluctuation.setEndTime(forecastFluctuation.getStartTime().plusDays(Math.abs(forecastFluctuationDays)));
//        forecastFluctuation.setType(type);
//        forecastFluctuationList.add(forecastFluctuation);
//    }
//
//    private Integer commonAdvise() {
//        BigDecimal inboundDecimal;
//        BigDecimal forecastInventory;
//        BigDecimal shortSupply;
//        BigDecimal addShortSupply;
//        for (int j = 0; j < autoForecastDay; j++) {
//            inboundDecimal = BigDecimal.valueOf(forecastInboundList.get(j));
//            totalInbound = totalInbound.add(inboundDecimal);
//            if (j == turnoverDays) {
//                dcAutoTurnover.setTurnoverInbound(totalInbound);
//            }
//            //计算预计库存 和 预计缺货
//            if (j == 0) {
//                if (outStock > 0) {
//                    //如果有缺货数, 第一天预计库存 =  预计入库 - 缺货数
//                    forecastInventory = BigDecimal.valueOf((forecastInboundList.get(j).doubleValue() - outStock.doubleValue()));
//                    shortSupply = forecastInventory.compareTo(BigDecimal.ZERO) < 0 ? forecastInventory.abs() : BigDecimal.ZERO;//库存补入后的 缺货数
//                    BigDecimal subtract = forecastSalesList.get(j).subtract(forecastInventory.compareTo(BigDecimal.ZERO) > 0 ? forecastInventory : BigDecimal.ZERO);//今天的缺货数
//                    shortSupply = subtract.add(shortSupply).compareTo(BigDecimal.ZERO) > 0 ? subtract.add(shortSupply) : BigDecimal.ZERO;
//                } else {
//                    //否则, 第一天预计库存 =  真实库存 + 预计入库
//                    forecastInventory = BigDecimal.valueOf((forecastInboundList.get(j).doubleValue() + realInventory.doubleValue()));
//                    BigDecimal subtract = forecastSalesList.get(j).subtract(forecastInventory);
//                    shortSupply = subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO;
//                }
//                forecastShortSupplyList.set(j, forecastShortSupplyList.get(j).add(shortSupply));
//            } else {
//                forecastInventory = inboundDecimal.add(forecastInventoryList.get(j - 1)).subtract(forecastSalesList.get(j - 1));
//                //库存先补断货
//                //为负的情况下, 应该为0
//                if (forecastInventory.compareTo(BigDecimal.ZERO) < 0) {
//                    forecastInventory = BigDecimal.ZERO;
//                }
//                addShortSupply = forecastInventory.subtract(forecastShortSupplyList.get(j - 1));
//                if (addShortSupply.compareTo(BigDecimal.ZERO) < 0) {
//                    forecastInventory = BigDecimal.ZERO;
//                    forecastShortSupplyList.set(j, addShortSupply.abs());
//                } else {
//                    forecastShortSupplyList.set(j, BigDecimal.ZERO);
//                    forecastInventory = addShortSupply;
//                }
//                BigDecimal subtract = forecastSalesList.get(j).subtract(forecastInventory);//今日断货
//                shortSupply = subtract.compareTo(BigDecimal.ZERO) > 0 ? subtract : BigDecimal.ZERO;
//                forecastShortSupplyList.set(j, forecastShortSupplyList.get(j).add(shortSupply));
//            }
//            forecastInventoryList.set(j, forecastInventory.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : forecastInventory);
//            //在两倍周转期内, 如果预测销量 <= 库存, 那么又是可用的一天
//            if (j < Constant.TURNOVER_MULTIPLE * turnoverDays && forecastSalesList.get(j).compareTo(forecastInventory) <= 0) {
//                inventoryAvailableDays++;
//            }
//
//            //库存 - 销量, 继续跑
//            if (j >= turnoverDays) {
//                BigDecimal totalAdvised = BigDecimal.ZERO;
//                boolean firstAdvice = true;
//                if (j == turnoverDays) {
//                    if (warehouseCode.equals(WAREHOUSE_JIT) && (turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_1) || turnoverSku.getBuyerName().equals(Constant.BUYER_JIT_2))) {
//                        BigDecimal saveDays = saveDaysMap.get("saveDays");
//                        totalSales = dcAutoTurnover.getDailyWeightedSales().multiply(BigDecimal.valueOf(turnoverDays));
//                        dcAutoTurnover.setTurnoverSales(totalSales);
//                        BigDecimal transNumber = BigDecimal.ZERO;
//                        BigDecimal forecastInbound;
//                        if (saveDays != null) {
//                            for (int trans = 0; trans < autoForecastDay; trans++) {
//                                forecastInbound = BigDecimal.valueOf(forecastInboundList.get(trans));
//                                transNumber = transNumber.add(forecastInbound);
//                            }
//                            totalSales = dcAutoTurnover.getDailyWeightedSales().multiply(saveDays);
//                            totalAdvised = totalSales.subtract(BigDecimal.valueOf(transNumber.doubleValue())) //累计到货
//                                    .subtract(outStock > 0 ? BigDecimal.ZERO : BigDecimal.valueOf(realInventory.longValue())) //真实库存,如果缺货就不减
//                                    .add(BigDecimal.valueOf(outStock.longValue())); //今天的实际缺货
//                            firstAdvice = false;
//                        }
//                    } else if (warehouseCode.equals(Constant.WAREHOUSE_JIT1) && (turnoverSku.getBuyerName().equals(Constant.BUTER_JIT_5))) {
//
//                        BigDecimal saveDays = saveDaysMap.get("saveDays");
//                        totalSales = dcAutoTurnover.getDailyWeightedSales().multiply(BigDecimal.valueOf(turnoverDays));
//                        dcAutoTurnover.setTurnoverSales(totalSales);
//                        if (saveDays != null) {
//                            totalSales = dcAutoTurnover.getDailyWeightedSales().multiply(saveDays);
//                            totalAdvised = totalSales
//                                    //真实库存,如果缺货就不减
//                                    .subtract(outStock > 0 ? BigDecimal.ZERO : BigDecimal.valueOf(realInventory.longValue()))
//                                    .subtract(outStock01 > 0 ? BigDecimal.ZERO : ((dcBaseStock != null && dcBaseStock.getUsableStock() != null) ? BigDecimal.valueOf(dcBaseStock.getUsableStock()) : BigDecimal.ZERO)) //广州014仓库存
//                                    .subtract(BigDecimal.valueOf(purchase + transfer)); //广州001仓在途数
//                            firstAdvice = false;
//                        }
//                    } else {
//                        dcAutoTurnover.setTurnoverSales(totalSales);
//                    }
//                }
//                if (firstAdvice) {
//                    totalAdvised = totalSafeInventory
////                            .subtract(forecastInventoryList.get(j > 0 ? j - 1 : 0))//安全库存缺少值= 理论安全库存  - 预测库存
//                            .add(BigDecimal.valueOf(outStock.longValue()))//今天的实际缺货
//                            .add(totalSales)//累计销量
//                            .subtract(BigDecimal.valueOf(totalInbound.doubleValue()))//累计到货
//                            .subtract(outStock > 0 ? BigDecimal.ZERO : BigDecimal.valueOf(realInventory.longValue())) //真实库存,如果缺货就不减
//                            .add(forecastSalesList.get(Math.max(j - 1, 0)));//预计销量
//                }
//
//                //采购建议数如果大于1的时候就向上取整。如果小于1就四舍五入
//                if (totalAdvised.compareTo(BigDecimal.ONE) > 0) {
//                    totalAdvised = totalAdvised.setScale(0, RoundingMode.CEILING);
//                } else {
//                    totalAdvised = totalAdvised.setScale(0, RoundingMode.HALF_EVEN);
//                }
//                forecastPurchaseAdvisedList.add(totalAdvised);
//                if (totalAdvised.compareTo(moqDecimal) > 0) {
//                    moqPurchaseAdvisedList.add(totalAdvised);
//                } else if (totalAdvised.compareTo(BigDecimal.ZERO) <= 0) {
//                    moqPurchaseAdvisedList.add(BigDecimal.ZERO);
//                } else {
//                    moqPurchaseAdvisedList.add(moqDecimal);
//                }
//            }
//            totalSales = totalSales.add(forecastSalesList.get(j));
//        }
//        return inventoryAvailableDays;
//    }
//
//    private final DcAutoConfigDeliveryMapper dcAutoConfigDeliveryMapper;
//    private final DcAutoInboundMapper autoInboundMapper;
//
//    //todo
//    private DcMidTransit dcMidTransit;
//
//    private void autoTurnoverUseDcAutoSales() {
//
//        //周转预测销量 + 初始化周转
//        List<DateTurnover> dateTurnoverList = dateSalesService.forecast(dcAutoTurnover, autoForecastDay);
//
//        List<DcBaseWeekCoefficient> dcBaseWeekCoefficientList = dcBaseWeekCoefficientMapper.selectByDays2(dateTurnoverList, dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode());
//        List<SalesDayConfig> salesDayConfigMapperList = salesDayConfigMapper.selectByDays2(dateTurnoverList, dcAutoTurnover.getBailunSku(), dcAutoTurnover.getWarehouseCode());
//
//        //周转预测销量 周系数
//        if (ListUtil.isNotEmpty(dcBaseWeekCoefficientList)) {
//            Map<LocalDate, DcBaseWeekCoefficient> weekCoefficientMap = dcBaseWeekCoefficientList.stream().collect(Collectors.toMap(DcBaseWeekCoefficient::getWeekDate, dcBaseWeekCoefficient -> dcBaseWeekCoefficient));
//            dateTurnoverList.forEach(item -> {
//                DcBaseWeekCoefficient coefficient = weekCoefficientMap.get(item.getDate());
//                if (coefficient != null) {
//                    item.setWeekCoefficient(new BigDecimal(coefficient.getCoefficient()));
//                }
//            });
//        }
//        //周转 销量配置
//        if (ListUtil.isNotEmpty(salesDayConfigMapperList)) {
//            Map<LocalDate, SalesDayConfig> salesDayConfigMap = salesDayConfigMapperList.stream().collect(Collectors.toMap(salesDayConfig -> salesDayConfig.getDate().toLocalDate(), salesDayConfig -> salesDayConfig));
//            dateTurnoverList.forEach(item -> {
//                SalesDayConfig salesDayConfig = salesDayConfigMap.get(item.getDate());
//                if (salesDayConfig != null) {
//                    item.setSalesDayConfig(salesDayConfig.getSales());
//                }
//            });
//        }
//
//        //计算周转显示销量
//        dateTurnoverList.forEach(DateTurnover::calcShowSales);
//
//        this.expectedStorage();
//
//        //通过SKU和仓库拿到实际库存
//        Integer realInventory = (dcBaseStock != null && dcBaseStock.getUsableStock() != null) ? dcBaseStock.getUsableStock() : 0;
//
//        BigDecimal totalSafeInventory = calculateSafeInventory();
//
//        Integer moq = dcBaseSku.getMoq();
//
//        Integer inventoryAvailableDays = 0;
//        BigDecimal totalSales = BigDecimal.ZERO;//周转期总销量
//        BigDecimal totalInbound = BigDecimal.ZERO;//周转期总预计入库
//        BigDecimal moqDecimal = BigDecimal.valueOf(moq.longValue());
//
//
//        Integer historyFourteenSales = 0;
//        Integer historySevenSales = 0;
//        Integer historyThreeSales = 0;
//        Integer historyThirtySales = 0;
//        for (int i = 0; i < 30; i++) {
//            if (i < 3) {
//                historyThreeSales += historySalesList.get(27 + i);
//            }
//            if (i < 7) {
//                historySevenSales += historySalesList.get(23 + i);
//            }
//            if (i < 14) {
//                historyFourteenSales += historySalesList.get(16 + i);
//            }
//            historyThirtySales += historySalesList.get(i);
//        }
//        BigDecimal avgHistoryThreedaySales = BigDecimal.valueOf(historyThreeSales.longValue()).divide(Constant.BIGDECIMAL_THREE, 3, RoundingMode.HALF_EVEN);
//        BigDecimal avgHistorySevendaySales = BigDecimal.valueOf(historySevenSales.longValue()).divide(Constant.BIGDECIMAL_SEVEN, 3, RoundingMode.HALF_EVEN);
//        BigDecimal avgHistoryFourteendaySales = BigDecimal.valueOf(historyFourteenSales.longValue()).divide(Constant.BIGDECIMAL_FOURTEEN, 3, RoundingMode.HALF_EVEN);
//        BigDecimal avgHistoryThirtydaySales = BigDecimal.valueOf(historyThirtySales.longValue()).divide(Constant.BIGDECIMAL_THIRTY, 3, RoundingMode.HALF_EVEN);
//
//        List<DcAutoForecastFluctuation> forecastFluctuationList = new ArrayList<>(turnoverDays);
//        //看是否监控状态
//        DcAutoConfigSkuWarehouse dcAutoConfigSkuWarehouse = this.getAutoConfigSkuWarehouse(bailunSku, warehouseCode);
//
//        //是否开启监控波动功能
//        boolean hasMonitorFluctuation = actualForecastFluctuations(dcAutoTurnover, forecastSalesList, realInventory, totalSafeInventory, dcAutoConfigSkuWarehouse, avgHistoryFourteendaySales);
//
//        if (dcBaseWarehouse.getSystemFlag().toUpperCase().equals(PlatformType.FBA.value())) {
//
//            inventoryAvailableDays = fbaAdvise();
//
//        } else {
//            inventoryAvailableDays = commonAdvise();
//        }
//
//        if (hasMonitorFluctuation) {
//            DcAutoForecastFluctuation dcAutoForecastFluctuationActual = null;
//            BigDecimal forecastPurchaseAdvise = forecastPurchaseAdvisedList.get(0);
//
//            if (forecastPurchaseAdvise.compareTo(BigDecimal.ZERO) < 0) {
//
//                //实际冗余
//                if (forecastPurchaseAdvise.add(dcAutoTurnover.getTurnoverInbound()).compareTo(BigDecimal.ZERO) < 0) {
//                    dcAutoForecastFluctuationActual = new DcAutoForecastFluctuation();
//                    //实际冗余
//                    dcAutoForecastFluctuationActual.setType(3);
//                    dcAutoForecastFluctuationActual.setQuantity(Math.abs(forecastPurchaseAdvise.add(dcAutoTurnover.getTurnoverInbound()).intValue()));
//                }
//                //预计冗余
//                else {
//                    dcAutoForecastFluctuationActual = new DcAutoForecastFluctuation();
//                    //实际冗余
//                    dcAutoForecastFluctuationActual.setType(4);
//                    dcAutoForecastFluctuationActual.setQuantity(Math.abs(forecastPurchaseAdvise.intValue()));
//                }
//            }
//
//            if (outStock > 0) {
//                dcAutoForecastFluctuationActual = new DcAutoForecastFluctuation();
//                //实际缺货
//                dcAutoForecastFluctuationActual.setType(1);
//                dcAutoForecastFluctuationActual.setQuantity(outStock);
//            }
//
//            if (dcAutoForecastFluctuationActual != null) {
//                dcAutoForecastFluctuationActual.setAvgSalesThree(avgHistoryThreedaySales);
//                dcAutoForecastFluctuationActual.setStartTime(recordTime);
//                dcAutoForecastFluctuationActual.setEndTime(recordTime);
//                forecastFluctuationList.add(dcAutoForecastFluctuationActual);
//            }
//        }
//
//        if (hasMonitorFluctuation) {
//            unusualFluctuation();
//        }
//
//        //拿一下2倍周转期内的入库总数
//        Integer quantityInbound = 0;
//        for (int i1 = 0; i1 < Constant.TURNOVER_MULTIPLE * turnoverDays; i1++) {
//            quantityInbound += forecastInboundList.get(i1);
//        }
//        //todo forecastInventoryList
//        //todo forecastShortSupplyList
//        //todo forecastInboundList forecastInboundRelationList
//
//
//        Integer stockUpDays = getStockUpDays(warehouseCode);
//
//        BigDecimal avgForecastOnedaySales = forecastSalesList.get(0);
//        BigDecimal avgForecastSevendaySales = BigDecimal.ZERO;
//        BigDecimal avgForecastFourteendaySales = BigDecimal.ZERO;
//        BigDecimal avgForecastTurnoverDaySales = BigDecimal.ZERO;
//        BigDecimal stockUpSales = BigDecimal.ZERO;
//        int fourteenTurnoverDays = Math.max(turnoverDays, 14);
//
//        for (int i = 0; i < fourteenTurnoverDays; i++) {
//            if (i < 7) {
//                avgForecastSevendaySales = avgForecastSevendaySales.add(forecastSalesList.get(i));
//                forecastSalesList.add(i, BigDecimal.valueOf(historySalesList.get(23 + i)));
//                forecastSalesListFormula.add(i, StringUtils.SPACE);
//                forecastSalesExplainList.add(i, "历史销量");
//                forecastInboundList.add(i, 0);
//                forecastInventoryList.add(i, BigDecimal.ZERO);
//                forecastShortSupplyList.add(i, BigDecimal.ZERO);
//            }
//            if (i < 14) {
//                avgForecastFourteendaySales = avgForecastFourteendaySales.add(forecastSalesList.get(i));
//            }
//            avgForecastTurnoverDaySales = avgForecastTurnoverDaySales.add(forecastSalesList.get(i));
//            if (i < stockUpDays - 1 && forecastPurchaseAdvisedList.get(0).compareTo(BigDecimal.ZERO) > 0) {
//                stockUpSales = stockUpSales.add(forecastSalesList.get(i + 1 + turnoverDays));
//            }
//        }
//
//        calculatePlatformAvgSales(dcAutoTurnover);
//        dcAutoTurnover.setSuppliersName(dcBaseSku.getSuppliersName());
//        dcAutoTurnover.setBuyerName(dcBaseSku.getBuyerName());
//        dcAutoTurnover.setBailunCategoryId(dcBaseSku.getBailunCategoryId());
//        dcAutoTurnover.setProductCode(dcBaseSku.getProductCode());
//        dcAutoTurnover.setProductInnerCode(dcBaseSku.getProductInnerCode());
//        dcAutoTurnover.setPaymentBeforeDelivery(paymentBeforeDelivery);
//        dcAutoTurnover.setStockUpDays(stockUpDays);
//        dcAutoTurnover.setStockUpSales(stockUpSales);
//        dcAutoTurnover.setQuantityBeginAdvise(forecastPurchaseAdvisedList.get(0));
//        if (turnoverDays == 0) {
//            dcAutoTurnover.setForecastTurnoverdaySales(avgForecastTurnoverDaySales);
//        } else {
//            dcAutoTurnover.setForecastTurnoverdaySales(avgForecastTurnoverDaySales.divide(BigDecimal.valueOf(turnoverDays), 3, RoundingMode.HALF_EVEN));
//        }
//        dcAutoTurnover.setSalesExplainDetails(forecastSalesExplainList.toString());
//        dcAutoTurnover.setHistorySevendaySales(avgHistorySevendaySales);
//        dcAutoTurnover.setHistoryFourteendaySales(avgHistoryFourteendaySales);
//        dcAutoTurnover.setHistoryThirtydaySales(avgHistoryThirtydaySales);
//        dcAutoTurnover.setSupplementarySales(forecastSalesList.get(turnoverDays));
//        dcAutoTurnover.setAverageSupplierDelivery(dcAutoTurnover.getSupplierDelivery());
//
//        //销量上线
//        dcAutoTurnover.setSalesUpperLimit(salesUpperLimit);
//        dcAutoTurnover.setAverageOverdue(BigDecimal.ZERO);
//        dcAutoTurnover.setAdvisedDetails(moqPurchaseAdvisedList.toString());
//        //周转预测销量
//        dcAutoTurnover.setSalesDetails(forecastSalesList.toString());
//        //周转预测入库
//        dcAutoTurnover.setInboundDetails(forecastInboundList.toString());
//        //周转预测库存
//        dcAutoTurnover.setInventoryDetails(forecastInventoryList.toString());
//        //周转预测断货
//        dcAutoTurnover.setShortSupplyDetails(forecastShortSupplyList.toString());
//
//        dcAutoTurnover.setForecastOnedaySales(avgForecastOnedaySales.compareTo(BigDecimal.ZERO) > 0 ? avgForecastOnedaySales.setScale(3, RoundingMode.HALF_EVEN) : BigDecimal.ZERO);
//        dcAutoTurnover.setForecastSevendaySales(avgForecastSevendaySales.compareTo(BigDecimal.ZERO) > 0 ? avgForecastSevendaySales.divide(Constant.BIGDECIMAL_SEVEN, 3, RoundingMode.HALF_EVEN) : BigDecimal.ZERO);
//        dcAutoTurnover.setForecastFourteendaySales(avgForecastFourteendaySales.compareTo(BigDecimal.ZERO) > 0 ? avgForecastFourteendaySales.divide(Constant.BIGDECIMAL_FOURTEEN, 3, RoundingMode.HALF_EVEN) : BigDecimal.ZERO);
//        dcAutoTurnover.setQuantityInbound(quantityInbound);
//        dcAutoTurnover.setInventoryAvailableDays(inventoryAvailableDays);
//        dcAutoTurnover.setSkuTitle(dcBaseSku.getSkuTitleCn());
//        dcAutoTurnover.setPromotions(promotionsBuilder.toString());
//
//        if ((warehouseCode.equals(WAREHOUSE_JIT) && (dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_1) || dcBaseSku.getBuyerName().equals(Constant.BUYER_JIT_2))) || (warehouseCode.equals(Constant.WAREHOUSE_JIT1) && (dcBaseSku.getBuyerName().equals(Constant.BUTER_JIT_5)))) {
//            dcAutoTurnover.setQuantityInitAdvise(forecastPurchaseAdvisedList.get(0));
//        } else {
//            dcAutoTurnover.setQuantityInitAdvise(forecastPurchaseAdvisedList.get(0).add(stockUpSales));
//        }
//        //如果初始建议数 + 备货数 > moq建议数, 那么moq建议数 + 备货数, 否则, 还是取moq建议数
//        BigDecimal subtract = dcAutoTurnover.getQuantityInitAdvise().subtract(moqPurchaseAdvisedList.get(0));
//        dcAutoTurnover.setQuantityFinalAdvise(moqPurchaseAdvisedList.get(0));
//        if (subtract.compareTo(BigDecimal.ZERO) > 0) {
//            dcAutoTurnover.setQuantityFinalAdvise(moqPurchaseAdvisedList.get(0).add(subtract));
//        }
//        dcAutoTurnover.setQuantityMinimumOrder(turnoverSku.getMoq());
//        dcAutoTurnover.setQuantityInventory(realInventory);
//        dcAutoTurnover.setQuantityPurchase(purchase);
//        dcAutoTurnover.setQuantityTransfer(transfer);
//        dcAutoTurnover.setQuantityOutStock(outStock);
//        dcAutoTurnover.setStatus((byte) (forecastShortSupplyList.get(2 * turnoverDays).intValue() > 0 ? 1 : 0));
//        dcAutoTurnover.setTurnoverDays(turnoverDays);
//        dcAutoTurnover.setQuantitySafeInventory(totalSafeInventory);
//        dcAutoTurnover.setHqType(dcBaseWarehouse.getHqType());
//        dcAutoTurnover.setSalesDetailsFormula(new Gson().toJson(forecastSalesListFormula));
//
//        dcAutoTurnover.setIsOutStock(0);
//
//
//        int i = autoTurnoverMapper.updateByExampleSelective(dcAutoTurnover, DcAutoTurnoverExample.newAndCreateCriteria().andBailunSkuEqualTo(dcAutoTurnover.getBailunSku()).andWarehouseCodeEqualTo(dcAutoTurnover.getWarehouseCode()).example());
//        if (i == 0) {
//            autoTurnoverMapper.insertSelective(dcAutoTurnover);
//        }
//
//    }
//
//
//}
