package com.bailuntec.job;


import com.bailuntec.domain.dto.SalesVolumeWeekDTO;
import com.bailuntec.domain.entity.DcAutoWeekSales;
import com.bailuntec.domain.entity.DcBaseWarehouse;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseWarehouseExample;
import com.bailuntec.mapper.*;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.ExceptionUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.sun.org.apache.regexp.internal.RE;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import java.text.MessageFormat;
import java.util.List;

public class CalculateWarehouseWeekJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {

        try{
            long count = 0;
            DcBaseWarehouseMapper dcBaseWarehouseMapper = SessionUtil.getSession().getMapper(DcBaseWarehouseMapper.class);
            count = dcBaseWarehouseMapper.countByExample(DcBaseWarehouseExample.newAndCreateCriteria().example());
            /*if (StringUtils.isBlank(shardingContext.getJobParameter())) {
                count = dcBaseWarehouseMapper.countByExample(DcBaseWarehouseExample.newAndCreateCriteria().example());
            } else {
                count = dcBaseWarehouseMapper.countByExample(DcBaseWarehouseExample.newAndCreateCriteria().andHqTypeEqualTo(shardingContext.getJobParameter()).example());
            }*/
            int totalPage = (int)(count % jobPointLog.getPageSize() == 0 ? count/jobPointLog.getPageSize() : count/jobPointLog.getPageSize() + 1);
            do{
                List<DcBaseWarehouse> dcBaseWarehouses = null;//分页查SKU_仓库
                if (jobPointLog.getPageIndex().equals(0)) {
                    jobPointLog.setPageIndex(totalPage);
                }
                try {
                    dcBaseWarehouseMapper = SessionUtil.getSession().getMapper(DcBaseWarehouseMapper.class);
                    /*if (StringUtils.isBlank(shardingContext.getJobParameter())) {
                        dcBaseWarehouses = dcBaseWarehouseMapper.selectByExample(DcBaseWarehouseExample.newAndCreateCriteria().example().page(jobPointLog.getPageIndex()*jobPointLog.getPageSize(), jobPointLog.getPageSize()));
                    }else{
                        dcBaseWarehouses = dcBaseWarehouseMapper.selectByExample(DcBaseWarehouseExample.newAndCreateCriteria().andHqTypeEqualTo(shardingContext.getJobParameter()).example().page(jobPointLog.getPageIndex()*jobPointLog.getPageSize(), jobPointLog.getPageSize()));
                    }*/
                    dcBaseWarehouses = dcBaseWarehouseMapper.selectByExample(DcBaseWarehouseExample.newAndCreateCriteria().example().page(jobPointLog.getPageIndex() - 1, jobPointLog.getPageSize()));
                    DcAutoSalesMapper autoSalesMapper = null;
                    if (dcBaseWarehouses != null && dcBaseWarehouses.size() > 0) {
                        for (DcBaseWarehouse dcBaseWarehouse : dcBaseWarehouses) {
                            autoSalesMapper = SessionUtil.getSession().getMapper(DcAutoSalesMapper.class);
                            SalesVolumeWeekDTO salesVolumeWeekDTO = autoSalesMapper.getSalesVolumeWeekDTO("", dcBaseWarehouse.getWarehouseCode());
                            if(StringUtils.isNotEmpty(salesVolumeWeekDTO.getSalesDetail().trim())) {
                                calculateWeekRate(salesVolumeWeekDTO);
                            }
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }finally {
                    SessionUtil.closeSession();
                }
                if (jobPointLog.getPageIndex() % 10 == 0) {
                    try {
                        JobPointLogMapper mapper = SessionUtil.getSession().getMapper(JobPointLogMapper.class);
                        mapper.upsertSelective(jobPointLog);
                    } catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(ExceptionUtil.transform(e), e);
                    } finally {
                        SessionUtil.closeSession();
                    }
                }
                jobPointLog.setPageIndex(jobPointLog.getPageIndex() - 1);
            }while(0 < jobPointLog.getPageIndex());
            jobPointLog.setPageIndex(0);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            SessionUtil.closeSession();
        }
    }

    public void calculateWeekRate(SalesVolumeWeekDTO salesVolumeWeekDTO) {
        try{
            DcAutoWeekSales dcAutoWeekSales = new DcAutoWeekSales();
            DcAutoWeekSalesMapper dcAutoWeekSalesMapper = SessionUtil.getSession().getMapper(DcAutoWeekSalesMapper.class);
            BeanUtils.copyProperties(dcAutoWeekSales, salesVolumeWeekDTO);
            dcAutoWeekSales.setSaleDetail(salesVolumeWeekDTO.getSalesDetail());
            dcAutoWeekSales.setRateDetail(salesVolumeWeekDTO.getRateDetail());
            dcAutoWeekSalesMapper.warehouseUpsertSelective(dcAutoWeekSales);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            SessionUtil.closeSession();
        }
    }



}
