import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.request.SkuCondition;
import com.bailuntec.domain.request.SkumsRequest;
import com.bailuntec.job.SkuMSSyncJob;
import com.bailuntec.utils.OkHttpUtil;
import okhttp3.*;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.time.LocalDateTime;

public class SyncSkuTest {

    private OkHttpClient client = OkHttpUtil.getInstance();

    @Test
    public void test() {
        SkuMSSyncJob skuSyncJob = new SkuMSSyncJob();
        skuSyncJob.executeJob(null, new JobPointLog("base-sku", 1, 100, 1, 1,
                LocalDateTime.of(2020, 9, 1, 10, 29),
                LocalDateTime.of(2020, 9, 1, 10, 31)));
    }

    @Test
    public void test2() {
        SkuMSSyncJob skuSyncJob = new SkuMSSyncJob();
        skuSyncJob.executeJob(null, new JobPointLog("base-sku", 1, 100, 1, 1,
                LocalDateTime.of(2020, 8, 28, 5, 43),
                LocalDateTime.of(2020, 8, 28, 5, 45)));
    }


    @Test
    public void test3() throws IOException {
        SkumsRequest skumsRequest = new SkumsRequest();
        skumsRequest.setConditionJson(JSON.toJSONString(new SkuCondition(LocalDateTime.of(2020, 9, 1, 10, 27),
                LocalDateTime.of(2020, 9, 1, 10, 35))));

        skumsRequest.setPageNumber(1);

        MediaType mediaType = MediaType.parse("application/json");
        skumsRequest.setPageIndex(1);
        RequestBody body = RequestBody.create(mediaType, JSON.toJSONString(skumsRequest));
        Request request = new Request.Builder()
                .url("http://api.skums.bailuntec.com/api/sku/productsku/gmtproductskus")
                .post(body)
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;

        response = client.newCall(request).execute();
        String resultStr = response.body().string();
        System.out.println(resultStr);

    }
}
