package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.entity.DcBaseSkuSimpleCategory;
import com.bailuntec.domain.enumerate.HttpStatus;
import com.bailuntec.domain.example.DcBaseSkuSimpleCategoryExample;
import com.bailuntec.domain.pojo.SkuSimpleCategory;
import com.bailuntec.domain.pojo.SkuSimpleCategoryResult;
import com.bailuntec.mapper.DcBaseSkuSimpleCategoryMapper;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;

import java.io.IOException;
import java.time.LocalDateTime;

public class SkuSimpleCategoryJob implements SimpleJob {
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    private OkHttpClient client = OkHttpUtil.getInstance();
    @Override
    public void execute(ShardingContext shardingContext) {
        Request request = new Request.Builder()
                .url(propertiesUtil.getPropertyAsString("SKU_SIMPLE_CATEGORY_URL"))
                .get()
                .addHeader("Content-Type", "application/json")
                .build();
        Response response  = null;
        try {
            response  = client.newCall(request).execute();
            SkuSimpleCategoryResult skuSimpleCategoryResult = JSON.parseObject(response.body().byteStream(), SkuSimpleCategoryResult.class);
            if (skuSimpleCategoryResult.getStatusCode().equals(200)) {
                if (skuSimpleCategoryResult.getResult() != null && skuSimpleCategoryResult.getResult().size() > 0) {
                    DcBaseSkuSimpleCategory dcBaseSkuSimpleCategory = new DcBaseSkuSimpleCategory();
                    DcBaseSkuSimpleCategoryMapper mapper = SessionUtil.getSession().getMapper(DcBaseSkuSimpleCategoryMapper.class);
                    for (SkuSimpleCategory skuSimpleCategory : skuSimpleCategoryResult.getResult()) {
                        try {
                            BeanUtils.copyProperties(dcBaseSkuSimpleCategory, skuSimpleCategory);
                        } catch (Exception e) {
                            throw  new RuntimeException("BeanUtils.copyProperties失败",e);
                        }
                        dcBaseSkuSimpleCategory.setBjModified(LocalDateTime.now());
                        int i = mapper.updateByExampleSelective(dcBaseSkuSimpleCategory, DcBaseSkuSimpleCategoryExample.newAndCreateCriteria().andSkumsIdEqualTo(dcBaseSkuSimpleCategory.getSkumsId()).example());
                        if (i == 0) {
                            dcBaseSkuSimpleCategory.setBjCreate(LocalDateTime.now());
                            mapper.insertSelective(dcBaseSkuSimpleCategory);
                        }
                    }
                }
            } else {
                throw  new RuntimeException("调用SKU简单分类接口返回错误");
            }
        } catch (IOException e) {
           throw new RuntimeException("调用SKU简单分类接口失败" + e.getCause().getMessage(), e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }
}
