import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.pojo.FbaStockData;
import com.bailuntec.domain.pojo.FbaStockInfo;
import com.bailuntec.job.FbaStockJob;
import com.bailuntec.job.WmsStockJob;
import com.bailuntec.utils.OkHttpUtil;
import okhttp3.*;
import org.apache.commons.beanutils.BeanUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;

public class DailyStockTest {
    @Test
    public void test() {
        FbaStockJob fbaStockJob = new FbaStockJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(1);
        jobPointLog.setPageSize(1000);
        fbaStockJob.executeJob(null,jobPointLog);
    }

    @Test
    public void test12() {
        WmsStockJob fbaStockJob = new WmsStockJob();
        JobPointLog jobPointLog = new JobPointLog();
        jobPointLog.setPageIndex(0);
        jobPointLog.setPageSize(1000);
        jobPointLog.setStartTime(LocalDateTime.of(2020,06,12,16,03,0));
        fbaStockJob.executeJob(null,jobPointLog);
    }

    @Test
    public void test2() {
        OkHttpClient client = OkHttpUtil.getInstance();
        MediaType mediaType = MediaType.parse("application/json");
        LinkedHashMap<String, Object> map = new LinkedHashMap<>(3);
        map.put("PageIndex", 1);
        map.put("PageRow", 100);
        RequestBody body = RequestBody.create(mediaType, JSON.toJSONString(map));
        Request request = new Request.Builder()
                .url("http://api.wms.bailuntec.com/api/services/app/ThirdStockFbaService/GetFbaStocks")
                .post(body)
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        } catch (IOException e) {
            throw new RuntimeException("调用wms系统FBA库存接口失败", e);
        }
        if (response != null && response.isSuccessful()) {
            JSONObject jsonObject = null;
            try {
                jsonObject = JSON.parseObject(response.body().string());
            } catch (IOException e) {
                throw new RuntimeException("解析wms系统FBA库存接口JSON数据失败", e);
            } finally {
                if (response != null) {
                    response.close();
                }
            }
            if (jsonObject.get("isSuccess") != null && jsonObject.getBooleanValue("isSuccess")) {
                FbaStockData fbaStockData = jsonObject.getObject("data", FbaStockData.class);
                if (fbaStockData != null && fbaStockData.getStocks() != null && fbaStockData.getStocks().size() > 0) {
                    DcBaseStock dcBaseStock;
                    for (FbaStockInfo fbaStockInfo : fbaStockData.getStocks()) {
                        dcBaseStock = new DcBaseStock();
                        //拆分SKU
                        try {
                            BeanUtils.copyProperties(dcBaseStock, fbaStockInfo);
                        } catch (IllegalAccessException e) {
                            e.printStackTrace();
                            throw new RuntimeException(" BeanUtils.copyProperties操作wms系统FBA库存数据失败",e);
                        } catch (InvocationTargetException e) {
                            e.printStackTrace();
                            throw new RuntimeException(" BeanUtils.copyProperties操作wms系统FBA库存数据失败",e);
                        }
                        System.out.println("...");
                    }
                }
            }
        }
    }
}
