import com.bailuntec.domain.constant.Constant;
import com.bailuntec.domain.entity.DcBaseCostFirst;
import com.bailuntec.domain.entity.DcBaseSku;
import com.bailuntec.domain.entity.DcMidCostFirst;
import com.bailuntec.domain.entity.DcMidCostFirstConfig;
import com.bailuntec.domain.example.DcBaseCostFirstExample;
import com.bailuntec.domain.example.DcBaseSkuExample;
import com.bailuntec.domain.example.DcMidCostFirstExample;
import com.bailuntec.domain.pojo.CostFirstOrder;
import com.bailuntec.domain.pojo.MidCostFirst;
import com.bailuntec.job.CalculateCostFirstJob;
import com.bailuntec.listener.CalculateCostFirstListener;
import com.bailuntec.mapper.*;
import com.bailuntec.utils.SessionUtil;
import org.junit.jupiter.api.Test;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class CostFirstTest {


    @Test
    public void test11()
    {
        try {
            DcBaseSkuMapper dcBaseSkuMapper = SessionUtil.getSession().getMapper(DcBaseSkuMapper.class);
            DcBaseSku dcBaseSku = dcBaseSkuMapper.selectOneByExample(DcBaseSkuExample.newAndCreateCriteria().andBailunSkuEqualTo("S31").example());
            System.out.println(dcBaseSku);
        } catch (Exception e) {
            throw new RuntimeException("MYBATIS操作DB查询SKU失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }

    @Test
    public void test() {
        CalculateCostFirstJob costFirstJob = new CalculateCostFirstJob();
        try {
            DcBaseCostFirstMapper dcBaseCostFirstMapper = SessionUtil.getSession().getMapper(DcBaseCostFirstMapper.class);
            //拿到物流单号, 将物流单中每个SKU的费用算出来
            List<CostFirstOrder> channelOrderIdList = dcBaseCostFirstMapper.listChannelOrderId(0, 1);
            if (channelOrderIdList != null && channelOrderIdList.size() > 0) {
                for (CostFirstOrder costFirstOrder : channelOrderIdList) {
                    costFirstOrder.setChannelOrderId("GZQY20190412 ");
                    costFirstOrder.setTransferOrderId("DB190412112032208");
                    DcBaseCostFirstMapper dcBaseCostFirstMapperFor = SessionUtil.getSession().getMapper(DcBaseCostFirstMapper.class);
                    List<DcBaseCostFirst> dcBaseCostFirsts = dcBaseCostFirstMapperFor.selectByExample(DcBaseCostFirstExample.newAndCreateCriteria().andChannelOrderIdEqualTo(costFirstOrder.getChannelOrderId()).andTransferOrderIdEqualTo(costFirstOrder.getTransferOrderId()).example());
                    costFirstJob.handleChannelOrderSku(dcBaseCostFirsts);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
        CalculateCostFirstListener calculateCostFirstListener = new CalculateCostFirstListener();
        calculateCostFirstListener.afterJobExecuted(null);
    }
    @Test
    public void  test1() {
        try {
            DcMidCostFirstOrderMapper dcMidCostFirstOrderMapper = SessionUtil.getSession().getMapper(DcMidCostFirstOrderMapper.class);
            DcMidCostFirstConfigMapper dcMidCostFirstConfigMapper = SessionUtil.getSession().getMapper(DcMidCostFirstConfigMapper.class);
            DcMidCostFirstMapper dcMidCostFirsMapper = SessionUtil.getSession().getMapper(DcMidCostFirstMapper.class);
            int countSkuWarehouse = dcMidCostFirstOrderMapper.countSkuWarehouse();
            int skuWarehouseTotalPage = getSkuWarehouseTotalPage(countSkuWarehouse);
            int index = 0;
            do {
                List<MidCostFirst> midCostFirstList = dcMidCostFirstOrderMapper.listSkuWarehouse(index * Constant.PAGE_SIZE,Constant.PAGE_SIZE);
                if (midCostFirstList != null && midCostFirstList.size() > 0) {
                    DcMidCostFirst dcMidCostFirst = new DcMidCostFirst();
                    for (MidCostFirst midCostFirst : midCostFirstList) {
                        dcMidCostFirst.setBailunSku(midCostFirst.getBailunSku());
                        dcMidCostFirst.setWarehouseCode(midCostFirst.getWarehouseCode());
                        BigDecimal costFirst = midCostFirst.getTotalCostFirst().divide(BigDecimal.valueOf(midCostFirst.getTotalCount()), 3 , RoundingMode.HALF_EVEN);
                        DcMidCostFirstConfig dcMidCostFirstConfig = dcMidCostFirstConfigMapper.getConfig(dcMidCostFirst.getBailunSku(),dcMidCostFirst.getWarehouseCode());
                        dcMidCostFirst.setCostFirst(costFirst);
                        if (dcMidCostFirstConfig != null) {
                            dcMidCostFirst.setCostFirst((costFirst.add(dcMidCostFirstConfig.getCostFirstConfig())).divide(BigDecimal.valueOf(2), 3, RoundingMode.HALF_EVEN));
                        }
                        int i = dcMidCostFirsMapper.updateByExampleSelective(dcMidCostFirst, DcMidCostFirstExample.newAndCreateCriteria().andBailunSkuEqualTo(dcMidCostFirst.getBailunSku()).andWarehouseCodeEqualTo(dcMidCostFirst.getWarehouseCode()).example());
                        if (i == 0) {
                            dcMidCostFirsMapper.insertSelective(dcMidCostFirst);
                        }
                    }
                }
                index++;
            } while (index < skuWarehouseTotalPage);
        } catch (Exception e) {
            throw new RuntimeException("在计算头程费到DcMidCostFirst时失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }
    private int getSkuWarehouseTotalPage(int countSkuWarehouse) {
        if (countSkuWarehouse % Constant.PAGE_SIZE == 0) {
            return countSkuWarehouse / Constant.PAGE_SIZE;
        }
        return countSkuWarehouse / Constant.PAGE_SIZE + 1;
    }
}
