package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.CompanyMainBodyDTO;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DcCompanyMainBodyMapper {
    @Insert("<script>" +
            "insert into dc_company_main_body(company_value,company_name) values " +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.companyValue},#{item.companyName})" +
            "</foreach>" +
            "on duplicate key update company_name=values (company_name)"+
            "</script>")
    void insertOrUpdateCompany(List<CompanyMainBodyDTO> companyMainBodyDTOList);

    @Select("select company_value,company_name from dc_company_main_body where do_balance_sheet=1")
    List<CompanyMainBodyDTO> getDoBalanceSheetCompanyValue();
}
