package com.bailuntec.domain.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 每日周转数据（预测销量）
 * </p>
 *
 * @author robbendev
 * @since 2021/1/14 4:55 下午
 */
@Data
public class DateTurnover {

    //实际销量
    private BigDecimal sales;
    //预测销量
    private BigDecimal forecastSales;
    //预测销量公式
    private String forecastSalesFormula;
    //预测销量解释
    private String forecastSalesExplain;
    //日期
    private LocalDate date;
    //周系数
    private BigDecimal weekCoefficient;
    //每日销量配置
    private BigDecimal salesDayConfig;
    //sku
    private String bailunSku;
    //仓库
    private String warehouseCode;
    //aims最终显示的销量
    private BigDecimal showSales;
    //入库释义
    private String inboundRelation;
    //预计入库数量
    private BigDecimal forecastInbound;
    //预测缺货数量
    private BigDecimal forecastShortSupply;
    //mop 采购建议
    private BigDecimal moqPurchaseAdvised;
    //预测采购建议
    private BigDecimal forecastPurchaseAdvised;
    //预计库存
    private BigDecimal forecastInventory;
    //p_表示采购单Id, t_表示调拨单Id, 用_连接调拨在途数量
    private String forecastInboundRelation;
    //预测采购入库
    private BigDecimal forecastPurchaseInbound;
    //预测调拨入库
    private BigDecimal forecastTransferInbound;

    public void calcShowSales() {
        this.showSales = sales;
        if (salesDayConfig != null) {
            this.showSales = salesDayConfig;

        }
    }

}
