/*
 * Copyright 1999-2015 dangdang.com.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package io.elasticjob.lite.internal.election;

import org.junit.Test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public final class LeaderNodeTest {
    
    private LeaderNode leaderNode = new LeaderNode("test_job");
    
    @Test
    public void assertIsLeaderInstancePath() {
        assertTrue(leaderNode.isLeaderInstancePath("/test_job/leader/election/instance"));
    }
    
    @Test
    public void assertIsNotLeaderInstancePath() {
        assertFalse(leaderNode.isLeaderInstancePath("/test_job/leader/election/instance1"));
    }
}
