package com.bailuntec.job;

import com.bailuntec.domain.dto.TransferTransitQuantity;
import com.bailuntec.domain.entity.DcDailyTransitFrom;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.mapper.DcBaseTransferCompleteMapper;
import com.bailuntec.mapper.DcDailyTransitFromMapper;
import com.bailuntec.mapper.DcMidTransitMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Slf4j
public class DailyTransferJob implements SimpleJob {
    @Override
    public void execute(ShardingContext shardingContext) {
        LocalDate localDate = LocalDate.now();
        LocalDate lastLocalDate = localDate.minusDays(1L);
        SqlSession sqlSession = SessionUtil.getFactory().openSession(TransactionIsolationLevel.READ_UNCOMMITTED);
        try {
            DcDailyTransitFromMapper dcDailyTransitFromMapper = sqlSession.getMapper(DcDailyTransitFromMapper.class);
            List<TransferTransitQuantity> transferTransitQuantityList = dcDailyTransitFromMapper.selectQuantityTransferTransitFrom();
            if(transferTransitQuantityList != null) {
                dcDailyTransitFromMapper.calculateTransferTransitFrom(transferTransitQuantityList, lastLocalDate);
            }
            sqlSession.commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("计算调拨在途数失败",e);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
            }
        }

        try {
            DcDailyTransitFromMapper dcDailyTransitFromMapper = SessionUtil.getSession().getMapper(DcDailyTransitFromMapper.class);
            List<TransferTransitQuantity> transferTransitQuantityList = dcDailyTransitFromMapper.selectQuantityTransferDelivery(localDate);
            for(TransferTransitQuantity transferTransitQuantity : transferTransitQuantityList) {
                DcDailyTransitFrom dcDailyTransitFrom = new DcDailyTransitFrom();
                dcDailyTransitFrom.setBailunSku(transferTransitQuantity.getBailunSku());
                dcDailyTransitFrom.setWarehouseCode(transferTransitQuantity.getWarehouseCode());
                dcDailyTransitFrom.setQuantityTransferDelivery(transferTransitQuantity.getCount());
                dcDailyTransitFrom.setSourceWarehouseCode(transferTransitQuantity.getSourceWarehouseCode());
                dcDailyTransitFrom.setRecordTime(lastLocalDate);
                int result = dcDailyTransitFromMapper.upsertSelective(dcDailyTransitFrom);
            }

            dcDailyTransitFromMapper = SessionUtil.getSession().getMapper(DcDailyTransitFromMapper.class);
            List<TransferTransitQuantity> transferTransitQuantityList1 = dcDailyTransitFromMapper.selectQuantityTransferInbound(localDate);
            for(TransferTransitQuantity transferTransitQuantity : transferTransitQuantityList1) {
                DcDailyTransitFrom dcDailyTransitFrom = new DcDailyTransitFrom();
                dcDailyTransitFrom.setBailunSku(transferTransitQuantity.getBailunSku());
                dcDailyTransitFrom.setWarehouseCode(transferTransitQuantity.getWarehouseCode());
                dcDailyTransitFrom.setQuantityTransferInbound(transferTransitQuantity.getCount());
                dcDailyTransitFrom.setSourceWarehouseCode(transferTransitQuantity.getSourceWarehouseCode());
                dcDailyTransitFrom.setRecordTime(lastLocalDate);
                int result = dcDailyTransitFromMapper.upsertSelective(dcDailyTransitFrom);
            }



        }catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("计算近30天入库失败", e);
        }finally {
            SessionUtil.closeSession();
        }

        try{
            DcDailyTransitFromMapper dcDailyTransitFromMapper = SessionUtil.getSession().getMapper(DcDailyTransitFromMapper.class);
            dcDailyTransitFromMapper.updateSkuUnitPrice(lastLocalDate);
            dcDailyTransitFromMapper.updateWarehouseName(lastLocalDate);
            dcDailyTransitFromMapper.updateSourceWarehouseName(lastLocalDate);
        }catch (Exception e){
            e.printStackTrace();
            throw new RuntimeException("更改sku单价失败", e);
        }finally {
            SessionUtil.closeSession();
        }
    }
}
