package com.bailuntec.domain.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class AllSkuProductInfo {
    /// <summary>
    /// 产品主键
    /// </summary>
 @JSONField(name = "id")
    public Integer skumsId;

    /// <summary>
    /// 商品主键
    /// </summary>
// @JSONField(name = "")
    public Integer mainId;

    /// <summary>
    /// 内部商品编码
    /// </summary>
 @JSONField(name = "goodsCode")
    public String productInnerCode;

    /// <summary>
    /// 内部产品编码
    /// </summary>
 @JSONField(name = "productCode")
    public String bailunInnerSku;

    /// <summary>
    /// 商品编码
    /// </summary>
 @JSONField(name = "product")
    public String productCode;

    /// <summary>
    /// 产品编码
    /// </summary>
    @JSONField(name = "sku")
    public String bailunSku;

    /// <summary>
    /// 中文名称
    /// </summary>
 @JSONField(name = "cTitle")
    public String skuTitleCn;

    /// <summary>
    /// 英文名称
    /// </summary>
 @JSONField(name = "eTitle")
    public String skuTitleEn;

    /// <summary>
    /// 分类Id
    /// </summary>
 @JSONField(name = "categoryId")
    public Integer categoryId;


    /// <summary>
    /// 分类名称
    /// </summary>
 @JSONField(name = "categoryName")
    public String categoryName;

    /// <summary>
    /// 百伦分类Id
    /// </summary>
 @JSONField(name = "cateBailunId")
    public Integer bailunCategoryId;

    /// <summary>
    /// 百伦分类名称
    /// </summary>
 @JSONField(name = "cateBailunName")
    public String bailunCategoryName;

    /// <summary>
    /// 主图
    /// </summary>
    @JSONField(name = "mainImage")
    public String skuImage;

    /// <summary>
    /// 尺码图片
    /// </summary>
    @JSONField(name = "codeImage")
    public String sizeImage;

    /// <summary>
    /// 是否成品
    /// </summary>
 @JSONField(name = "isFinish")
    public Integer type;

    /// <summary>
    /// 颜色
    /// </summary>
 @JSONField(name = "color")
    public String color;

    /// <summary>
    /// 规格
    /// </summary>
 @JSONField(name = "size")
    public String specifications;

    /// <summary>
    /// 采购价
    /// </summary>
 @JSONField(name = "price")
    public BigDecimal unitPrice;

    /// <summary>
    /// 币种
    /// </summary>
 @JSONField(name = "currency")
    public String currency;

    /// <summary>
    /// 产品重量
    /// </summary>
 @JSONField(name = "weight")
    public BigDecimal weight;

    /// <summary>
    /// 单位
    /// </summary>
 @JSONField(name = "unit")
    public String unit;

    /// <summary>
    /// 包装重量
    /// </summary>
 @JSONField(name = "packingWeight")
    public BigDecimal packingWeight;

    /// <summary>
    /// 产品尺寸
    /// </summary>
 @JSONField(name = "productSize")
    public String productSize;

    /// <summary>
    /// 包装尺寸
    /// </summary>
 @JSONField(name = "packingSize")
    public String packingSize;

    /// <summary>
    /// 包装名称
    /// </summary>
 @JSONField(name = "packingName")
    public String packingName;

    /// <summary>
    /// 包装价格
    /// </summary>
 @JSONField(name = "packingPrice")
    public BigDecimal packingPrice;

    /// <summary>
    /// 充电器规格
    /// </summary>
 @JSONField(name = "chargerSpec")
    public Integer chargerSpecifications;

    /// <summary>
    /// 产品性质
    /// </summary>
 @JSONField(name = "productCharacter")
    public String productNature;

    /// <summary>
    /// 中文配货名
    /// </summary>
 @JSONField(name = "cPeiHuo")
    public String pickTitleCn;

    /// <summary>
    /// 英文配货名
    /// </summary>
 @JSONField(name = "ePeiHuo")
    public String pickTitleEn;

    /// <summary>
    /// 中文申报名
    /// </summary>
 @JSONField(name = "cBaoGuan")
    public String declareTitleCn;

    /// <summary>
    /// 英文申报名
    /// </summary>
 @JSONField(name = "eBaoGuan")
    public String declareTitleEn;

    /// <summary>
    /// 海关编码
    /// </summary>
 @JSONField(name = "hsCode")
    public String customsCode;

    /// <summary>
    /// 业务开发员Id
    /// </summary>
 @JSONField(name = "bussinessId",deserialize=false)
    public Integer bussinessId;

    /// <summary>
    /// 业务开发员名称
    /// </summary>
 @JSONField(name = "bussinessName",deserialize=false)
    public String bussinessName;

    /// <summary>
    /// 销售员Id -- 穗海说的,销售员和业务开发员是一个字段
    /// </summary>
 @JSONField(name = "bussinessId")
    public Integer sellerId;

    /// <summary>
    /// 销售员名称 - 暂缺 -- 穗海说的,销售员和业务开发员是一个字段
    /// </summary>
 @JSONField(name = "bussinessName")
    public String sellerName;

    /// <summary>
    /// 找货员
    /// </summary>
 @JSONField(name = "bargainer")
    public String bargainer;

    /// <summary>
    /// 采购员Id
    /// </summary>
 @JSONField(name = "buyer")
    public Integer buyerId;

    /// <summary>
    /// 采购员名称
    /// </summary>
 @JSONField(name = "buyerName")
    public String buyerName;

    /// <summary>
    /// 采购仓库
    /// </summary>
 @JSONField(name = "wareCode")
    public String warehouseCode;
    /// <summary>
    /// 采购仓库
    /// </summary>
 @JSONField(name = "wareName")
    public String warehouseName;

    /// <summary>
    /// 贴标要求
    /// </summary>
// @JSONField(name = "")
    public String labelReq;

    /// <summary>
    /// 质检要求
    /// </summary>
// @JSONField(name = "")
    public String zhijianReq;

    /// <summary>
    /// 质检工时
    /// </summary>
 @JSONField(name = "testHour")
    public BigDecimal inspectionHours;

    /// <summary>
    /// 商品状态 1停售，2在售
    /// </summary>
 @JSONField(name = "status")
    public Integer status;

    /// <summary>
    /// 推送产品库状态 1推送
    /// </summary>
 @JSONField(name = "productStatus")
    public Integer pushStatus;

    /// <summary>
    /// 是否启用
    /// </summary>
 @JSONField(name = "enable")
    public Integer enable;

    /// <summary>
    /// 上传状态 0未上传，1已上传
    /// </summary>
// @JSONField(name = "")
    public Integer isUpApi;

    /// <summary>
    /// 同步状态 0未同步，1已同步，-1同步失败
    /// </summary>
// @JSONField(name = "")
    public Integer lastUpdateState;

    /// <summary>
    /// 同步失败原因
    /// </summary>
// @JSONField(name = "")
    public String reason;

    /// <summary>
    /// 虚拟采购价
    /// </summary>
 @JSONField(name = "virPrice")
    public BigDecimal virtualPrice;

    /// <summary>
    /// 销售价格
    /// </summary>
 @JSONField(name = "salesPrice")
    public BigDecimal salesPrice;

    /// <summary>
    /// 供应商Id
    /// </summary>
 @JSONField(name = "deliverId")
    public Integer suppliersId;

    /// <summary>
    /// 供应商名称
    /// </summary>
 @JSONField(name = "deliverName")
    public String suppliersName;

    /// <summary>
    /// 供应商链接
    /// </summary>
 @JSONField(name = "link")
    public String suppliersLink;

    /// <summary>
    /// 最小订单量
    /// </summary>
 @JSONField(name = "moq")
    public Integer moq;

    /// <summary>
    /// 内部最小订单量
    /// </summary>
 @JSONField(name = "internalMoq")
    public Integer internalMoq;

    /// <summary>
    /// 交期
    /// </summary>
 @JSONField(name = "delivery")
    public Integer supplierDelivery;

    /// <summary>
    /// 备注
    /// </summary>
// @JSONField(name = "")
    public String remark;

    /// <summary>
    /// 组合关系
    /// </summary>
// @JSONField(name = "")
    public String GroupRelete;

    /// <summary>
    /// 更新人
    /// </summary>
 @JSONField(name = "updateName")
    public String updateName;

    /// <summary>
    /// 更新时间
    /// </summary>
 @JSONField(name = "updateTime")
    public LocalDateTime updateTime;

    /// <summary>
    /// 创建人
    /// </summary>
 @JSONField(name = "createName")
    public String createName;

    /// <summary>
    /// 创建人
    /// </summary>
 @JSONField(name = "createTime")
    public LocalDateTime createTime;

    /// <summary>
    /// 返回所有供应商列表
    /// </summary>
// @JSONField(name = "")
    public List<GetSupplierInfo> spList;

    /// <summary>
    /// 返回sku仓库信息列表
    /// </summary>
//  @JSONField(name = "")
    public List<GetWareAreaInfo> wareList;




}
