package com.bailuntec.balancesheet.controller;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.balancesheet.dto.LogisticsSupplierTransactionDTO;
import com.bailuntec.balancesheet.dto.SupplierTransactionDTO;
import com.bailuntec.balancesheet.service.BalanceSheetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
public class BalanceSheetController {
    @Autowired
    private BalanceSheetService balanceSheetService;

    private  static Logger logger = LoggerFactory.getLogger(BalanceSheetController.class);

    @GetMapping("/generate")
    public String doScheduledTask(){
        try{
            balanceSheetService.doScheduledTask0000();
        }catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>生成资产负债表出错" + e.getMessage());
            return "生成资产负债表出错";
        }
        return "生成资产负债表成功";
    }

    @GetMapping("/test")
    public String test(){
        return "OK";
    }

    /**
     * 更新调整后的供应商往来数据：应付账款和预付账款
     * @return
     */
    @PostMapping("/adjustSupplierTransaction")
    public String adjustSupplierTransaction(@RequestBody String updateData){
        JSONObject result = new JSONObject();
        try{
            List<SupplierTransactionDTO> supplierTransactionDTOList = JSONObject.parseArray(updateData, SupplierTransactionDTO.class);
            if(supplierTransactionDTOList != null && supplierTransactionDTOList.size() > 0){
                balanceSheetService.adjustSupplierTransaction(supplierTransactionDTOList);
            }
            result.put("success", true);
            result.put("message", "success");
        } catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>更新调整后的供应商往来数据失败" + e.getMessage());
            result.put("success", false);
            result.put("message", "更新调整后的供应商往来数据失败" + e.getMessage());
        }
        return result.toString();
    }

    /**
     * 更新调整后的物流供应商往来数据：应付账款和预付账款
     * @return
     */
    @PostMapping("/adjustLogisticsSupplierTransaction")
    public String adjustLogisticsSupplierTransaction(@RequestBody String updateData){
        JSONObject result = new JSONObject();
        try{
            List<LogisticsSupplierTransactionDTO> logisticsSupplierTransactionDTOList = JSONObject.parseArray(updateData, LogisticsSupplierTransactionDTO.class);
            if(logisticsSupplierTransactionDTOList != null && logisticsSupplierTransactionDTOList.size() > 0){
                balanceSheetService.adjustLogisticsSupplierTransaction(logisticsSupplierTransactionDTOList);
            }
            result.put("success", true);
            result.put("message", "success");
        } catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>更新调整后的物流供应商往来数据失败" + e.getMessage());
            result.put("success", false);
            result.put("message", "更新调整后的物流供应商往来数据失败" + e.getMessage());
        }
        return result.toString();
    }

    @GetMapping("/updateSheetLogisticsSupplier")
    public String updateSheetLogisticsSupplier(@RequestParam(value = "date", required = true) String date, @RequestParam(value = "logisticsPayableSum", required = true) BigDecimal logisticsPayableSum) {
        JSONObject result = new JSONObject();
        try{
            balanceSheetService.updateSheetSuppliserTransaction(date, logisticsPayableSum);
            result.put("success", true);
            result.put("message", "success");
        } catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>更新调整后的物流供应商往来数据失败" + e.getMessage());
            result.put("success", false);
            result.put("message", "更新调整后的物流供应商往来数据失败" + e.getMessage());
        }
        return result.toString();
    }

}
