package com.bailuntec.ebay_uk_report.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT1 = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT2 = "yyyy-MM-dd HH:mm:ss";

    /**
     * 日期字符串转换为Date对象
     * @param dateStr
     * @param pattern
     * @return
     * @throws ParseException
     */
    public static Date stringToDate(String dateStr, String pattern){
        if(isNotEmpty(dateStr)){
            try {
                return new SimpleDateFormat(pattern).parse(dateStr.trim());
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * Date对象转换为日期字符串
     * @param date
     * @param pattern
     * @return
     */
    public static String dateToString(Date date, String pattern){
        return new SimpleDateFormat(pattern).format(date);
    }

    /**
     * 日期字符串是否为空
     * @param dateStr
     * @return
     */
    public static boolean isNotEmpty(String dateStr){
        return dateStr != null && !"".equals(dateStr.trim());
    }

    /**
     * 获取距离某日期特定月数的月份的第一天
     * @param monthNumber 要加减的月数
     * @return
     */
    public static Date getMonthFirstDay(Date date, int monthNumber){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, monthNumber);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return calendar.getTime();
    }

    /**
     * 获取距离特定日期天数的日期
     * @param date
     * @param days 要加减的天数
     * @return 加减后的日期
     */
    public static Date addDays(Date date, int days){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, days);
        return calendar.getTime();
    }

    /**
     * 获取当前月第一天
     * @return
     */
    public static Date getCurrentMonthFirstDay(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return stringToDate(dateToString(calendar.getTime(), DATE_FORMAT), DATE_FORMAT);
    }

    /**
     * 获取当前月最大日期
     * @return
     */
    public static Date getCurrentMonthMaxDay(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DATE));
        return stringToDate(dateToString(calendar.getTime(), DATE_FORMAT), DATE_FORMAT);
    }

    /**
     * 获取今天的日期
     * @return
     */
    public static Date getCurrentDay(){
        Calendar calendar = Calendar.getInstance();
        return stringToDate(dateToString(calendar.getTime(), DATE_FORMAT), DATE_FORMAT);
    }

    /**
     * 获取今天的昨天日期
     * @return
     */
    public static Date getCurrentLastDay(){
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        return stringToDate(dateToString(calendar.getTime(), DATE_FORMAT), DATE_FORMAT);
    }


    public static void main(String[] args) {
        System.out.println(dateToString(getCurrentLastDay(), DATE_FORMAT));
    }

}
