package com.bailuntec;

import com.alibaba.druid.pool.DruidDataSource;
import com.bailuntec.job.AutoTurnoverJob;
import com.bailuntec.job.QueueConsumerJob;
import com.bailuntec.job.ReplaceLogisticJob;
import com.bailuntec.utils.PropertiesUtil;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;

import javax.sql.DataSource;

@Slf4j
@MapperScan("com.bailuntec.mapper")
public class Application {
    private static PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("job");
    private static final String EVENT_RDB_STORAGE_DRIVER = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_DRIVER");
    private static final String EVENT_RDB_STORAGE_URL = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_URL");
    private static final String EVENT_RDB_STORAGE_USERNAME = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_USERNAME");
    private static final String EVENT_RDB_STORAGE_PASSWORD = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_PASSWORD");

    public static void main(String[] args) {

        log.info("starting app...");
//
        new JobScheduler(createRegistryCenter(),
                createJobConfigurationNormal()).init();

        new JobScheduler(createRegistryCenter(),
                createJobConfigurationIncrement()).init();

        new JobScheduler(createRegistryCenter(),
                createReplaceLogistic()).init();

        new JobScheduler(createRegistryCenter(),
                createQueueConsumer()).init();

        new JobScheduler(createRegistryCenter(),
                createJobConfigurationNeNormal()).init();

//        new JobScheduler(createRegistryCenter(),
//                createJobConfigurationWeek()).init();

    }

    private static LiteJobConfiguration createQueueConsumer() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                "queueConsumer2",
                "0/1 * * * * ? ",
                8)
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, QueueConsumerJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }


    private static LiteJobConfiguration createReplaceLogistic() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                "ReplaceLogistic",
                "0/1 * * * * ? ",
                1)
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, ReplaceLogisticJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }

    private static CoordinatorRegistryCenter createRegistryCenter() {
        CoordinatorRegistryCenter regCenter = new ZookeeperRegistryCenter(new ZookeeperConfiguration(propertiesUtil.getPropertyAsString("ZOOKEEPER_SERVER"),
                propertiesUtil.getPropertyAsString("NAME_SPACE")));
        regCenter.init();
        return regCenter;
    }

    //
    private static LiteJobConfiguration createJobConfigurationNormal() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                propertiesUtil.getPropertyAsString("JOB_NAME"),
                propertiesUtil.getPropertyAsString("JOB_CRON"),
                propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT"))
                .jobParameter("NORMAL")
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, AutoTurnoverJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }

    private static LiteJobConfiguration createJobConfigurationWeek() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                propertiesUtil.getPropertyAsString("JOB_NAME_WEEK"),
                propertiesUtil.getPropertyAsString("JOB_WEEK_CRON"),
                propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT"))
                .jobParameter("NORMAL")
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, AutoTurnoverJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }



    private static LiteJobConfiguration createJobConfigurationNeNormal() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                propertiesUtil.getPropertyAsString("JOB_NAME_NE_NORMAL"),
                propertiesUtil.getPropertyAsString("JOB_CRON_NE_NORMAL"),
                propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT"))
                .jobParameter("NE_NORMAL")
                .build();

        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, AutoTurnoverJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }

    private static LiteJobConfiguration createJobConfigurationIncrement() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                propertiesUtil.getPropertyAsString("JOB_NAME_INCREMENT"),
                propertiesUtil.getPropertyAsString("JOB_CRON_INCREMENT"),
                propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT_INCREMENT"))
                .jobParameter("INCREMENT")
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, AutoTurnoverJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }

//
//    private static JobEventConfiguration createJobEventConfiguration() {
//        return new JobEventRdbConfiguration(setUpEventTraceDataSource());
//    }

    private static DataSource setUpEventTraceDataSource() {
        DruidDataSource result = new DruidDataSource();
        result.setDriverClassName(EVENT_RDB_STORAGE_DRIVER);
        result.setUrl(EVENT_RDB_STORAGE_URL);
        result.setUsername(EVENT_RDB_STORAGE_USERNAME);
        result.setPassword(EVENT_RDB_STORAGE_PASSWORD);
        return result;
    }

}
