# 百伦Java Maven依赖管理

## 如何使用

新项目继承
```xml
<parent>
        <artifactId>bailuntec-parent</artifactId>
        <groupId>com.bailuntec</groupId>
        <version>1.0-SNAPSHOT</version>
    </parent>
```

新的二方库添加到bailuntec-bom/pom.xml

新的三方库添加到bailuntec-dependencies/pom.xml


## 项目结构
```
├── bailuntec-bom   二方库依赖
├── bailuntec-dependencies 三方库依赖
└── bailuntec-parent  Java项目公共父亲pom
```

### 如何开发

#### 新增三方库依赖

bailuntec-dependencies/pom.xml添加
```xml
<properties>
...
    <commons-lang3.verson>3.10</commons-lang3.verson>
</properties>

<!--apache lang 工具包-->
<dependency>
    <groupId>org.apache.commons</groupId>
    <artifactId>commons-lang3</artifactId>
    <version>${commons-lang3.verson}</version>
</dependency>
```

#### 新增二方库依赖
bailuntec-bom/pom.xml添加

```xml
<properties>
    ...
    <bailuntec-cost-api.version>1.0-SNAPSHOT</bailuntec-cost-api.version>
</properties>

<dependency>
    <groupId>com.bailuntec</groupId>
    <artifactId>bailuntec-cost-api</artifactId>
    <version>${bailuntec-cost-api.version}</version>
</dependency>

```

发布: bailuntec-nexus目录下执行
```shell script
mvn clean deploy
```
