package com.bailuntec.task.config;

import com.bailuntec.domain.DcJobConfig;
import com.bailuntec.infrastructure.mapper.DcJobConfigMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 5:09 下午
 */
@Configuration
public class JobProperty {

    private DcJobConfig dcJobConfig;

    @Resource
    DcJobConfigMapper dcJobConfigMapper;

    @Value("${spring.application.name}")
    String applicationName;

    @PostConstruct
    void init() {
        dcJobConfig = dcJobConfigMapper.selectByName(applicationName);
        if (dcJobConfig == null) {
            dcJobConfig = new DcJobConfig();
            dcJobConfig.setJobName(applicationName);
            dcJobConfig.setRemark("每天生成ebay广告任务");
            dcJobConfigMapper.insert(dcJobConfig);

            dcJobConfig = dcJobConfigMapper.selectById(dcJobConfig.getId());
        }
    }

    public DcJobConfig getDcJobConfig() {
        return dcJobConfig;
    }

    public void setDcJobConfig(DcJobConfig dcJobConfig) {
        this.dcJobConfig = dcJobConfig;
    }
}
