package com.bailuntec.task.writer;

import com.bailuntec.application.IDcBaseFinanceEbayService;
import com.bailuntec.domain.DcBaseFinanceEbay;
import lombok.extern.slf4j.Slf4j;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/1/21 5:04 下午
 */
@Component
@Slf4j
public class  CustomerWriter implements ItemWriter<DcBaseFinanceEbay> {

    @Resource
    private IDcBaseFinanceEbayService dcBaseFinanceEbayService;

    @Override
    public void write(@NonNull List<? extends DcBaseFinanceEbay> items) {
        log.info("批量写入DcBaseFinanceEbay");
        dcBaseFinanceEbayService.InsertAllIgnoreExist(items.stream().map(var -> (DcBaseFinanceEbay) var).collect(Collectors.toList()));
    }
}
