package com.bailuntec.job.service;

import com.bailuntec.api.bailuntec.exceptionless.ExceptionlessApi;
import com.bailuntec.api.bailuntec.exceptionless.ExceptionlessInput;
import com.bailuntec.job.MidCalculateTransitApp;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/12 10:59 上午
 */
@EnableHystrix
@ActiveProfiles(value = "test")
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = MidCalculateTransitApp.class)
class MidCalculateTransitServiceTest {

    @Resource
    MidCalculateTransitService midCalculateTransitService;

    @Test
    void midCalculateOutStockQuantity() {
        midCalculateTransitService.midCalculateOutStockQuantity();
    }

    @Test
    void midCalculatePurchaseTransitQuantity() {
        midCalculateTransitService.midCalculatePurchaseTransitQuantity();
    }

    @Test
    void midCalculateTransferTransitQuantity() {
        midCalculateTransitService.midCalculateTransferTransitQuantity();
    }

    @Test
    void midCalculateNoShippedQuantity() {
        midCalculateTransitService.midCalculateNoShippedQuantity();
    }

    @Resource
    ExceptionlessApi exceptionlessApi;

    @Value("${exceptionless.token}")
    private String exceptionlessToken;

    @Test
    void exceptionless(){
        ExceptionlessInput input = ExceptionlessInput.builder()
                .source("midCalculateOutStockQuantity")
                .message("执行时间："+ LocalDateTime.now().toString())
                .build();
        exceptionlessApi
                .events(exceptionlessToken,input);
    }
}
