package com.bailuntec.infrastructure.util;

import com.bailuntec.api.bailuntec.www.BailuntecApi;
import com.bailuntec.api.bailuntec.www.response.GetExchangeRateByCurAndDateResp;
import com.bailuntec.common.SpringContextUtil;
import com.bailuntec.domain.DcExchangeRate;
import com.bailuntec.infrastructure.mapper.DcExchangeRateMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Slf4j
public class CallBailunSystemUtil {

    private static final LocalDateTime rateInitTime = LocalDateTime.of(2018, 1, 1, 0, 0, 0);

    /**
     * <p>获取每月月初的汇率</p>
     *
     * @param fromCurrency 源货币
     * @param toCurrency   目标货币
     * @param queryTime    时间
     * @return 汇率
     */

    public static BigDecimal getMonthExchangeRate(String fromCurrency, String toCurrency, LocalDateTime queryTime) {

        if (queryTime.isBefore(rateInitTime)) {
            queryTime = rateInitTime;
        }
        queryTime = queryTime.withDayOfMonth(1);
        return getMySqlExchangeRate(fromCurrency, toCurrency, queryTime.toLocalDate());
    }

    /**
     * <p>获取指定日期的汇率</p>
     *
     * @param fromCurrency 源货币
     * @param toCurrency   目标货币
     * @param queryTime    时间
     * @return 汇率
     */
    public static BigDecimal getExchangeRate(String fromCurrency, String toCurrency, LocalDateTime queryTime) {
        if (queryTime.isBefore(rateInitTime)) {
            queryTime = rateInitTime;
        }
        queryTime = queryTime.withDayOfMonth(1);
        return getMySqlExchangeRate(fromCurrency, toCurrency, queryTime.toLocalDate());
    }

    private static BigDecimal getMySqlExchangeRate(String fromCurrency, String toCurrency, LocalDate queryTime) {
        DcExchangeRateMapper dcExchangeRateMapper = SpringContextUtil.getBean(DcExchangeRateMapper.class);
        BailuntecApi bailuntecApi = SpringContextUtil.getBean(BailuntecApi.class);

        DcExchangeRate dcExchangeRate = dcExchangeRateMapper.selectOne(new LambdaQueryWrapper<DcExchangeRate>()
                .eq(DcExchangeRate::getInitCurreny, fromCurrency)
                .eq(DcExchangeRate::getFinalCurreny, toCurrency)
                .eq(DcExchangeRate::getRecordTime, queryTime));

        if (dcExchangeRate == null) {
            GetExchangeRateByCurAndDateResp res = bailuntecApi.getExchangeRateByCurAndDate(fromCurrency, toCurrency, DateTimeFormatter.ofPattern("yyyy-MM-dd").format(queryTime));

            dcExchangeRate = new DcExchangeRate();
            dcExchangeRate.setInitCurreny(fromCurrency);
            dcExchangeRate.setFinalCurreny(toCurrency);
            dcExchangeRate.setExchangeRate(res.getRate());
            dcExchangeRate.setRecordTime(queryTime);
            dcExchangeRateMapper.insert(dcExchangeRate);
        }

        return dcExchangeRate.getExchangeRate();
    }

}
