package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 平台账号余额表
 * </p>
 *
 * @author robbendev
 * @since 2020-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcPlatformBalance对象", description="平台账号余额表")
public class DcPlatformBalance implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "付款主体value")
    private Integer paycompanyid;

    @ApiModelProperty(value = "平台编码")
    private String platformcode;

    @ApiModelProperty(value = "平台名称")
    private String platformname;

    @ApiModelProperty(value = "账户名称")
    private String account;

    @ApiModelProperty(value = "币种")
    private String currency;

    @ApiModelProperty(value = "总余额（原币种）")
    private BigDecimal amount;

    @ApiModelProperty(value = "可用余额（原币种），可用余额=总余额-冻结余额")
    private BigDecimal userableAmount;

    @ApiModelProperty(value = "冻结余额（原币种）")
    private BigDecimal freezeAmount;

    @ApiModelProperty(value = "汇率（兑换人民币）")
    private BigDecimal exchangerate;

    @ApiModelProperty(value = "总余额（人民币）")
    private BigDecimal amountRmb;

    @ApiModelProperty(value = "可用余额（人民币）")
    private BigDecimal userableAmountRmb;

    @ApiModelProperty(value = "冻结余额（人民币）")
    private BigDecimal freezeAmountRmb;

    @ApiModelProperty(value = "销售额统计日期")
    private LocalDate day;

    @ApiModelProperty(value = "放款时间")
    private LocalDateTime puttime;

    @ApiModelProperty(value = "是否删除，1：已删除，0：未删除")
    private Integer delstatus;

    @ApiModelProperty(value = "数据来源")
    private String fromsource;

    @ApiModelProperty(value = "备注")
    private String notes;

    @ApiModelProperty(value = "上一期期末余额")
    private BigDecimal beforeBalance;

    @ApiModelProperty(value = "本期销售额")
    private BigDecimal amountSales;

    @ApiModelProperty(value = "本期提现金额")
    private BigDecimal withdrawAmount;

    @ApiModelProperty(value = "初始额统计日期")
    private LocalDate saleday;

    @ApiModelProperty(value = "期末余额")
    private BigDecimal endBalance;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createtime;

    @ApiModelProperty(value = "创建人id")
    private Integer createuserid;

    @ApiModelProperty(value = "创建人名称")
    private String createusername;


}
