package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * wms物流未对账数据
 * </p>
 *
 * @author robbendev
 * @since 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcBaseLogisticsReconciliation对象", description="wms物流未对账数据")
public class DcBaseLogisticsReconciliation implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private Integer wmsId;

    @TableField("company_Code")
    private String companyCode;

    @TableField("company_Name")
    private String companyName;

    @TableField("line_Code")
    private String lineCode;

    @TableField("line_Name")
    private String lineName;

    @TableField("allocatecargoOrderCode")
    private String allocatecargoOrderCode;

    @TableField("yiCangNo")
    private String yiCangNo;

    @TableField("trackingNo")
    private String trackingNo;

    @TableField("shipmentTime")
    private LocalDateTime shipmentTime;

    @TableField("outputWeightKg")
    private BigDecimal outputWeightKg;

    @TableField("bailunShipmentCostCNY")
    private BigDecimal bailunShipmentCostCNY;

    @TableField("merchantOutputWeightKg")
    private BigDecimal merchantOutputWeightKg;

    @TableField("merchantShipmentCostCNY")
    private BigDecimal merchantShipmentCostCNY;

    @TableField("merchantReconciliationTime")
    private LocalDateTime merchantReconciliationTime;

    @TableField("reconciliationStatus")
    private String reconciliationStatus;

    @TableField("weightDiff")
    private String weightDiff;

    @TableField("costDiff")
    private String costDiff;

    @TableField("weightSpecificDiff")
    private String weightSpecificDiff;

    @TableField("thisReconciliateTime")
    private LocalDateTime thisReconciliateTime;

    @TableField("originalScanningTime")
    private LocalDateTime originalScanningTime;

    @TableField("wareNo")
    private String wareNo;

    @TableField("reconciliationUser")
    private String reconciliationUser;

    @TableField("auditUser")
    private String auditUser;

    @TableField("auditStatus")
    private String auditStatus;

    @TableField("auditRemark")
    private String auditRemark;

    private String remark;

    @TableField("confirmShipmentCostCNY")
    private BigDecimal confirmShipmentCostCNY;

    @TableField("confirmOutputWeightKg")
    private BigDecimal confirmOutputWeightKg;

    @TableField("createUser")
    private String createUser;

    @TableField("creationTime")
    private LocalDateTime creationTime;

    @TableField("lastModificationTime")
    private LocalDateTime lastModificationTime;

    @TableField("gmt_createTime")
    private LocalDateTime gmtCreatetime;

    @TableField("gmt_modifyTime")
    private LocalDateTime gmtModifytime;


}
