package com.bailuntec.infrastructure.mapper;

import com.bailuntec.domain.DcSemiDailyTransfer;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;

/**
 * <p>
 * 半成品每天采购在途 Mapper 接口
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
public interface DcSemiDailyTransferMapper extends BaseMapper<DcSemiDailyTransfer> {

    @Select("select ifnull(sum(transfer_quantity * unit_price),0) from dc_semi_daily_transfer where day = #{lastDay}")
    BigDecimal getSemiDailyTransferSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum(transfer_quantity * unit_price),0) from dc_semi_daily_transfer where day = #{lastDay} and warehouse_id in (27,1,26,5,17,15,19,18,2)")
    BigDecimal getSemiBailunDailyTransferSum(@Param("lastDay") LocalDate lastDay);

    @Select("select ifnull(sum(transfer_quantity * unit_price),0) from dc_semi_daily_transfer where day = #{lastDay} and warehouse_id in (16,9)")
    BigDecimal getSemiHaNiDailyTransferSum(@Param("lastDay") LocalDate lastDay);
}
