package com.bailuntec.domain;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 半成品每天采购在途
 * </p>
 *
 * @author robbendev
 * @since 2020-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="DcSemiDailyTransfer对象", description="半成品每天采购在途")
public class DcSemiDailyTransfer implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "统计日期")
    private LocalDateTime day;

    @ApiModelProperty(value = "采购单ID")
    private Integer buyId;

    @ApiModelProperty(value = "采购明细ID")
    private Integer detailId;

    @ApiModelProperty(value = "采购单编号")
    private String buyNo;

    @ApiModelProperty(value = "供应商ID")
    private Integer supplierId;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "sku编码")
    private String skuCode;

    @ApiModelProperty(value = "sku名称")
    private String skuName;

    @ApiModelProperty(value = "仓库ID")
    private Integer warehouseId;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "在途数量")
    private BigDecimal transferQuantity;

    @ApiModelProperty(value = "采购单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "半成品系统最后更新时间")
    private LocalDateTime semiUpdateDate;

    @ApiModelProperty(value = "取数时间")
    private LocalDateTime updateTime;


}
