package com.bailuntec.job.service;

import com.bailuntec.application.IDcBaseOmsSkuService;
import com.bailuntec.application.IDcBaseOmsSkuTransferService;
import com.bailuntec.common.BeanUtils;
import com.bailuntec.common.ListUtil;
import com.bailuntec.domain.DcBaseOmsSku;
import com.bailuntec.domain.DcBaseOmsSkuTransfer;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/1 3:27 下午
 */
@ActiveProfiles("test")
@SpringBootTest(classes = TestApp.class)
class SyncFeeServiceTest extends AbstractTestNGSpringContextTests {

    @Resource
    SyncFeeService syncFeeService;

    @Test
    void syncFinanceFee() {
        syncFeeService.syncFinanceFee();
    }

    @Test
    void syncLogistics() {
    }

    @Test
    void syncManageCost() {
        syncFeeService.syncManageCost();
    }

    @Test
    void syncDailyFee() {
    }

    @Resource
    IDcBaseOmsSkuService dcBaseOmsSkuService;
    @Resource
    IDcBaseOmsSkuTransferService dcBaseOmsSkuTransferService;

    @Test
    public void testXX() {
        int pageNum = 1;
        int pageSize = 10000;
        Integer lastId = null;
        for (; ; ) {
            IPage<DcBaseOmsSku> page = new Page<>(pageNum, pageSize);

            LambdaQueryWrapper<DcBaseOmsSku> wrapper = new LambdaQueryWrapper<>();
            if (lastId != null) {
                wrapper.gt(DcBaseOmsSku::getId, lastId);
            }
            dcBaseOmsSkuService.page(page);
            if (ListUtil.isEmpty(page.getRecords())) {
                break;
            }
            List<DcBaseOmsSkuTransfer> dcBaseOmsSkuTransferList = page.getRecords()
                    .stream()
                    .map(dcBaseOmsSku -> {
                        DcBaseOmsSkuTransfer dcBaseOmsSkuTransfer = new DcBaseOmsSkuTransfer();
                        BeanUtils.copyProperties(dcBaseOmsSku, dcBaseOmsSkuTransfer);
                        return dcBaseOmsSkuTransfer;
                    })
                    .collect(Collectors.toList());
            dcBaseOmsSkuTransferService.saveBatch(dcBaseOmsSkuTransferList);
            lastId = page.getRecords().get(page.getRecords().size() - 1).getId();
        }

    }


}
