package com.bailuntec.infrastructure.mapper;

import com.bailuntec.api.bailuntec.purchase.resp.LogisticsSupplierTransactionDTO;
import com.bailuntec.domain.DcLogisticsSupplierTransaction;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in
 * @Modified by:
 */
public interface DcLogisticsSupplierTransactionMapper extends BaseMapper<DcLogisticsSupplierTransaction> {
    @Insert("<script>" +
            "insert into dc_logistics_supplier_transaction(day,type,pay_company_value,pay_company_name,supplier_id,supplier_name,start_amount," +
            "borrow_amount,loan_amount,end_amount) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.day},#{item.type},#{item.payCompanyValue},#{item.payCompanyName},#{item.supplierId},#{item.supplierName},#{item.startAmount}," +
            "#{item.borrowAmount},#{item.loanAmount},#{item.endAmount})" +
            "</foreach>" +
            "on duplicate key update type=values(type),pay_company_value=values(pay_company_value),pay_company_name=values(pay_company_name)," +
            "supplier_id=values(supplier_id),supplier_name=values(supplier_name),start_amount=values(start_amount),borrow_amount=values(borrow_amount)," +
            "loan_amount = values(loan_amount),end_amount = values(end_amount)" +
            "</script>")
    void insertOrUpdateLogisticsSupplierTransaction(List<LogisticsSupplierTransactionDTO> list);

    /**
     * 物流应付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_logistics_supplier_transaction where day = #{lastDay} and end_amount > 0")
    BigDecimal getLogisticsAccountsPayableSum(@Param("lastDay") LocalDate lastDay);

    /**
     * 物流预付款项汇总
     * @return
     */
    @Select("select sum(end_amount) from dc_logistics_supplier_transaction where day = #{lastDay} and end_amount < 0")
    BigDecimal getLogisticsPrepaymentSum(@Param("lastDay") LocalDate lastDay);
}
